message("UNIX non APPLE environment")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Debug ../development")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
# The TARGET changes according to the plaform
# For example, it changes to XtpCpp for macOS.
# Here we want it to be lowercase, UNIX-culture,
# and it is needed for the user manual build.
SET(TARGET xtpcpp)

## Install directories
if(NOT CMAKE_INSTALL_PREFIX)
  set(CMAKE_INSTALL_PREFIX /usr)
endif()
set(BIN_DIR ${CMAKE_INSTALL_PREFIX}/bin)
set(DOC_DIR ${CMAKE_INSTALL_PREFIX}/share/doc/${TARGET})



find_package(QCustomPlot REQUIRED)
# Per instructions of the lib author:
# https://www.qcustomplot.com/index.php/tutorials/settingup
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")
if(NOT TARGET QCustomPlot::QCustomPlot)
  add_library(QCustomPlot::QCustomPlot UNKNOWN IMPORTED)
  set_target_properties(QCustomPlot::QCustomPlot PROPERTIES
    IMPORTED_LOCATION             "${QCustomPlot_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlot_INCLUDE_DIR}"
    INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY	)
endif()



if (NOT OdsStream_FOUND)
    find_package( OdsStream REQUIRED )
endif (NOT OdsStream_FOUND)


set(PappsoMSpp_INCLUDE_DIR /home/langella/developpement/git/pappsomspp/src)
mark_as_advanced(PappsoMSpp_INCLUDE_DIR)
set(PappsoMSpp_INCLUDE_DIRS ${PappsoMSpp_INCLUDE_DIR})
# Look for the necessary library
set(PappsoMSpp_LIBRARY /home/langella/developpement/git/pappsomspp/build/src/libpappsomspp.so)
mark_as_advanced(PappsoMSpp_LIBRARY)
# Mark the lib as found
set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_LIBRARIES ${PappsoMSpp_LIBRARY})
if(NOT TARGET PappsoMSpp::Core)
    add_library(PappsoMSpp::Core UNKNOWN IMPORTED)
    set_target_properties(PappsoMSpp::Core PROPERTIES
        IMPORTED_LOCATION             "${PappsoMSpp_LIBRARY}"
        INTERFACE_INCLUDE_DIRECTORIES "${PappsoMSpp_INCLUDE_DIRS}")
endif()
set(PappsoMSppWidget_LIBRARY /home/langella/developpement/git/pappsomspp/build/src/pappsomspp/widget/libpappsomspp-widget.so)
mark_as_advanced(PappsoMSppWidget_LIBRARY)  
message(STATUS "~~~~~~~~~~~~~ ${PappsoMSppWidget_LIBRARY} ~~~~~~~~~~~~~~~")
set(PappsoMSppWidget_FOUND TRUE)
if(NOT TARGET PappsoMSpp::Widget)
    add_library(PappsoMSpp::Widget UNKNOWN IMPORTED)
    set_target_properties(PappsoMSpp::Widget PROPERTIES
        IMPORTED_LOCATION             "${PappsoMSppWidget_LIBRARY}"
        INTERFACE_INCLUDE_DIRECTORIES "${PappsoMSpp_INCLUDE_DIRS}")
endif()





if(NOT OdsStream_FOUND)
    find_package(OdsStream REQUIRED)
endif(NOT OdsStream_FOUND)


if(NOT PappsoMSpp_FOUND)
    find_package(PappsoMSpp REQUIRED)
endif(NOT PappsoMSpp_FOUND)


if(NOT RData_FOUND)
    find_package(RData REQUIRED)
endif(NOT RData_FOUND)

#sudo apt install libgrantlee5-dev
if(NOT Grantlee5_FOUND)
    find_package(Grantlee5 REQUIRED)
endif(NOT Grantlee5_FOUND)

