/**
 * \file src/gui/xic_view/xicworkerthread.h
 * \date 12/1/2018
 * \author Olivier Langella
 * \brief XIC worker
 */
/*******************************************************************************
 * Copyright (c) 2018 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#ifndef XICWORKERTHREAD_H
#define XICWORKERTHREAD_H

#include <pappsomspp/peptide/peptidenaturalisotopelist.h>
#include <QObject>
#include "../../core/msrun.h"
#include <pappsomspp/xic/xic.h>
#include <pappsomspp/xicextractor/msrunxicextractorfactory.h>
#include "xic_box/xicbox.h"
class XicWorkerThread : public QObject
{
  Q_OBJECT
  public:
  XicWorkerThread(XicBox *parent);
  virtual ~XicWorkerThread();
  public slots:
  void doXicLoad(MsRunSp p_msrun, std::vector<pappso::pappso_double> mz_list,
                 pappso::PrecisionPtr precision,
                 pappso::XicExtractMethod method);
  void doComputeIsotopeMassList(pappso::PeptideSp peptide_sp,
                                unsigned int charge,
                                pappso::PrecisionPtr precision,
                                double minimum_isotope_pattern_ratio);

  signals:
  void xicLoaded(std::vector<pappso::XicCstSPtr> xic_sp_list);
  void isotopeMassListComputed(
    std::vector<pappso::PeptideNaturalIsotopeAverageSp> isotope_mass_list);
  void operationFailed(QString error);

  private:
  std::vector<pappso::MsRunXicExtractorInterfaceSp> _extractor_list;
};
#endif // XICWORKERTHREAD_H
