/**
 * \file gui/export/export_masschroq_dialog/exportmasschroqdialog.h
 * \date 25/01/2019
 * \author Olivier Langella
 * \brief choose ODS export options
 */

/*******************************************************************************
 * Copyright (c) 2019 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#pragma once

#include <QDialog>
#include "masschroqfileparameters.h"
#include "../../../core/project.h"
#include "../../workerthread.h"

namespace Ui
{
class ExportMasschroqDialog;
}

class MainWindow;

class ExportMasschroqDialog : public QDialog
{
  Q_OBJECT


  public:
  explicit ExportMasschroqDialog(MainWindow *parent, WorkerThread *p_worker);
  ~ExportMasschroqDialog();
  void accept() override;
  void reject() override;

  void setMasschroqFileParameters(const MasschroqFileParameters &params);
  MasschroqFileParameters getMasschroqFileParameters() const;

  void setProjectSPtr(ProjectSp p_project);

  signals:
  // void peptideChanged(pappso::PeptideSp peptide);
  void operateFindBestMsrunForAlignment(ProjectSp project_sp);
  void operateCheckingMsrunFilePath(ProjectSp project_sp);


  public slots:
  void setBestMsrunForAlignment(MsRunSp msrun_sp);
  void setCheckMsrunFilePathOk(MsRunSp msrun_sp);

  private:
  Ui::ExportMasschroqDialog *ui;
  ProjectSp msp_project;
  MainWindow *mp_main;

  protected slots:
  void doCheckMsrunFilepath();
  void doBrowseMsrunDirectory();
  void doFindBestMsrunForAlignment();

  private:
  void fillMsrunListComboBox();

};
