/**
 * \file gui/edit/edit_settings/editsettings.cpp
 * \date 23/2/2019
 * \author Olivier Langella
 * \brief dialog box to edit global settings
 */

/*******************************************************************************
 * Copyright (c) 2019 Olivier Langella <olivier.langella@u-psud.fr>.
 *
 * This file is part of XTPcpp.
 *
 *     XTPcpp is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTPcpp is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <olivier.langella@u-psud.fr> - initial API and
 *implementation
 ******************************************************************************/

#include "editsettings.h"
#include <QDebug>
#include <QSettings>

#include "ui_edit_settings.h"

EditSettings::EditSettings(QWidget *parent)
  : QDialog(parent), ui(new Ui::EditSettingsDialog)
{
  ui->setupUi(this);
  QSettings settings;
  QString xic_extraction_method =
    settings.value("global/xic_extractor", "pwiz").toString();
  ui->xic_reader_buffered_button->setChecked(true);
  if(xic_extraction_method == "pwiz")
    {
      ui->xic_reader_buffered_button->setChecked(false);
    }
}


EditSettings::~EditSettings()
{
  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__;

  delete ui;
  qDebug() << __FILE__ << " " << __FUNCTION__ << " " << __LINE__;
}


void
EditSettings::done(int r)
{
  if(QDialog::Accepted == r) // ok was pressed
    {
      QString xic_extraction_method = "pwiz";
      if(ui->xic_reader_buffered_button->isChecked())
        {
          xic_extraction_method = "buffered";
        }

      QSettings settings;
      settings.setValue("global/xic_extractor", xic_extraction_method);
      QDialog::done(r);
      return;
    }
  else // cancel, close or exc was pressed
    {
      QDialog::done(r);
      return;
    }
}
