
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/


#ifndef _TYPES_H_
#define _TYPES_H_ 1

#include <cstdint>
/*********** enumerations *********************************/

/** \def ExternalDatabase external database references
 *
 */
enum class ExternalDatabase: std::int8_t {
    OboPsiMod =1, ///< OBO PSI MOD
    SwissProt =2, ///< Swiss-Prot
    TrEMBL=3, ///< TrEMBL
    AGI_LocusCode=4, ///< AGI_LocusCode
    NCBI_gi=5, ///< NCBI_gi
    ref=6 ///< ref
};

/** \def IdentificationEngine identification engine
 *
 */
enum class IdentificationEngine {
    unknown, ///< X!Tandem
    XTandem, ///< X!Tandem
    peptider ///< peptider
};

/** \def PeptideMatchParam peptide match specific parameters
 *
 */
enum class PeptideMatchParam {
    tandem_hyperscore ///< X!Tandem hyperscore
};

/** \def IdentificationEngineParam identification engine parameters
 *
 */
enum class IdentificationEngineParam {
    tandem_param ///< X!Tandem xml parameters file
};

/** \def GroupingType list of available grouping algoritms
 *
 */
enum class GroupingType {
    PeptideMass, ///< protein grouper algo
    Phospho, ///< phospho peptides grouping
    SampleScan ///< X!TandemPipeline algo
};


/** \def MzFormat mz data file format types
 *
 */

enum class MzFormat {
    unknown, ///< unknown format
    mzML, ///< mzML
    mzXML, ///< mzXML
    MGF, ///< Mascot format
};

/** \def ValidationState
 *
 */

enum class ValidationState: std::int8_t {
    notValid = 0,///< notValid : automatic filter validation failed
    valid =1, ///< valid : automatic filter validation passed
    validAndChecked=2, ///< validAndChecked : automatic filter validation passed + manual checking
    grouped=3 ///< grouped : automatic filter validation passed + manual checking + grouped
};


#endif /* _TYPES_H_ */
