
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of PAPPSOms-tools.
*
*     PAPPSOms-tools is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms-tools is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef READSPECTRUM_H
#define READSPECTRUM_H

#include <QString>
#include <pappsomspp/spectrum/qualifiedspectrum.h>
#include <pwiz/data/msdata/MSDataFile.hpp>
#include <map>
#include "../core/msrun.h"

pappso::Spectrum readSpectrum(const QString & filename, unsigned int scan_num,unsigned int & precursor_charge_state);

pwiz::msdata::MSDataFile * getPwizMSDataFile(const QString & filename);

pappso::QualifiedSpectrum getQualifiedSpectrumFromPwizMSDataFile(pwiz::msdata::MSDataFile * p_ms_data_file, unsigned int scan_num);

//MzFormat getPwizMSDataFileFormat(pwiz::msdata::MSDataFile * p_ms_data_file);

class SpectrumStore {
public:
    static pappso::SpectrumSp getSpectrumSpFromMsRunSp(MsRunSp msrun, unsigned int scan_num);
private:
    static const QString findMzFile(const QString &filename);
private:
    static std::map<MsRunSp, pwiz::msdata::MSDataFile *> _map_msrun_msdatafile;
};
#endif // READSPECTRUM_H
