/**
 * \file utils/identificationdatasourcestore.cpp
 * \date 5/4/2017
 * \author Olivier Langella
 * \brief store unique version of identification data sources (output files from identification engines)
 */


/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "identificationdatasourcestore.h"
#include "../core/identification_sources/identificationxtandemfile.h"
#include <pappsomspp/pappsoexception.h>

IdentificationDataSourceStore::IdentificationDataSourceStore()
{

}

IdentificationDataSourceStore::~IdentificationDataSourceStore()
{

}

IdentificationDataSourceSp IdentificationDataSourceStore::getInstance(const QString & location) {
qDebug() << "IdentificationDataSourceStore::getInstance begin " << location;
qDebug() << " " << _map_identification_data_sources.size();
    std::map< QString, IdentificationDataSourceSp >::iterator it = _map_identification_data_sources.find(location);
    if (it != _map_identification_data_sources.end()) {
        return it->second;
    }
    else {
        QFileInfo location_file(location);
        QString ext = location_file.suffix();
        //QString sample_name = location_file.baseName();
        if (ext.toLower() == "xml") {
            //X!Tandem result file
            IdentificationDataSourceSp p_xtfile = std::make_shared<IdentificationXtandemFile>(location_file);
            _map_identification_data_sources.insert(std::pair< QString, IdentificationDataSourceSp >(location, p_xtfile));
            _map_identification_data_sources.insert(std::pair< QString, IdentificationDataSourceSp >(location_file.absoluteFilePath(), p_xtfile));
            return p_xtfile;
        }
    }
    throw pappso::PappsoException(QObject::tr("Identification resource %1 not recognized").arg(location));
}


std::vector<IdentificationDataSourceSp> IdentificationDataSourceStore::getIdentificationDataSourceList() const {
    std::vector<IdentificationDataSourceSp> idsource_list;
    for (auto & msrun_pair :_map_identification_data_sources) {
        idsource_list.push_back(msrun_pair.second);
    }
    return idsource_list;
}
