/**
 * \file output/xpip.h
 * \date 13/4/2017
 * \author Olivier Langella
 * \brief XPIP writer
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef XPIP_H
#define XPIP_H

#include <QXmlStreamWriter>
#include <QFile>
#include <QString>
#include "../core/project.h"

class Xpip
{
        public:
    Xpip(const QString & out_filename);
    ~Xpip();

    void write(ProjectSp sp_project);
    void close();
  
private :
    QFile * _output_file;
    QXmlStreamWriter * _output_stream;
    ProjectSp _sp_project;

};

#endif // XPIP_H
