/**
 * \file gui/ptm_island_list_window/ptmislandlistwindow.h
 * \date 30/5/2017
 * \author Olivier Langella
 * \brief display all ptm islands
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PTMISLANDLISTWINDOW_H
#define PTMISLANDLISTWINDOW_H
#include <QMainWindow>
#include "ptmislandtablemodel.h"
#include "ptmislandproxymodel.h"
#include "../../core/identificationgroup.h"

class ProjectWindow;

//http://doc.qt.io/qt-4.8/qt-itemviews-chart-mainwindow-cpp.html
namespace Ui {
class PtmIslandListWindow;
}

class PtmIslandListWindow: public QMainWindow {
    Q_OBJECT
public:

    explicit PtmIslandListWindow(ProjectWindow * parent = 0);
    ~PtmIslandListWindow();
    void setIdentificationGroup(IdentificationGroup * p_identification_group);


public slots:
    void doIdentificationPtmGroupGrouped(IdentificationGroup * p_identification_group);
    void doIdentificationGroupGrouped(IdentificationGroup * p_identification_group);
    
signals:
  void ptmIslandDataChanged();

private:
    IdentificationGroup * _p_identification_group=nullptr;
    Ui::PtmIslandListWindow *ui;
    PtmIslandTableModel * _ptm_table_model_p = nullptr;
    PtmIslandProxyModel * _ptm_proxy_model_p = nullptr;
    ProjectWindow * _project_window;

};

#endif // PTMISLANDLISTWINDOW_H
