/**
 * \file gui/ptm_island_list_window/ptmislandlistwindow.cpp
 * \date 30/5/2017
 * \author Olivier Langella
 * \brief display all ptm islands
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "ptmislandlistwindow.h"


#include "ui_ptm_island_list_view.h"
#include "../mainwindow.h"
#include <QSettings>


PtmIslandListWindow::PtmIslandListWindow(ProjectWindow *parent):
    QMainWindow(parent),
    ui(new Ui::PtmIslandListWindow)
{
    _project_window = parent;
    ui->setupUi(this);
    /*
    */
    _ptm_table_model_p = new PtmIslandTableModel(this);


    _ptm_proxy_model_p = new PtmIslandProxyModel(this, _ptm_table_model_p);
    _ptm_proxy_model_p->setSourceModel(_ptm_table_model_p);
    _ptm_proxy_model_p->setDynamicSortFilter(true);
    ui->ptm_island_tableview->setModel( _ptm_proxy_model_p );
    ui->ptm_island_tableview->setSortingEnabled(true);
    ui->ptm_island_tableview->setAlternatingRowColors(true);



#if QT_VERSION >= 0x050000
    // Qt5 code
    /*
    connect(&workerThread, &QThread::finished, worker, &QObject::deleteLater);
    connect(this, &PtSpectrumViewer::operateMsDataFile, worker, &PwizLoaderThread::doMsDataFileLoad);
    connect(worker, &PwizLoaderThread::msDataReady, this, &PtSpectrumViewer::handleMsDataFile);
    */
#else
// Qt4 code
    connect (this, SIGNAL(ptmIslandDataChanged()), _ptm_table_model_p, SLOT(onPtmIslandDataChanged()));

    connect (_project_window, SIGNAL(identificationPtmGroupGrouped(IdentificationGroup *)), this,SLOT(doIdentificationPtmGroupGrouped(IdentificationGroup *)));
    connect (_project_window, SIGNAL(identificationGroupGrouped(IdentificationGroup *)), this,SLOT(doIdentificationGroupGrouped(IdentificationGroup *)));

#endif
}

PtmIslandListWindow::~PtmIslandListWindow()
{
    delete _ptm_table_model_p;
    delete _ptm_proxy_model_p;
}

void PtmIslandListWindow::setIdentificationGroup(IdentificationGroup * p_identification_group) {

    qDebug() << "PtmIslandListWindow::setIdentificationGroup begin " ;
    if (p_identification_group != nullptr) {
        qDebug() << "PtmIslandListWindow::setIdentificationGroup not null";
        _p_identification_group = p_identification_group;
        _ptm_table_model_p->setIdentificationGroup(p_identification_group);
        //_p_proxy_model->setSourceModel(_protein_table_model_p);


    }
    else {
        qDebug() << "PtmIslandListWindow::setIdentificationGroup  null";
    }

    qDebug() << "PtmIslandListWindow::setIdentificationGroup end";
}

void PtmIslandListWindow::doIdentificationGroupGrouped(IdentificationGroup * p_identification_group) {
    qDebug() << "PtmIslandListWindow::doIdentificationGroupGrouped begin";
    if (_p_identification_group == p_identification_group) {
        //ui->ptm_island_tableview->resizeRowToContents(_ptm_table_model_p->rowCount());
        _project_window->doPtmIslandGrouping(p_identification_group);
        //emit ptmIslandDataChanged();
    }

    qDebug() << "PtmIslandListWindow::doIdentificationGroupGrouped end";
}

void PtmIslandListWindow::doIdentificationPtmGroupGrouped(IdentificationGroup * p_identification_group) {
    qDebug() << "PtmIslandListWindow::doIdentificationPtmGroupGrouped begin";
    if (_p_identification_group == p_identification_group) {
        //ui->ptm_island_tableview->resizeRowToContents(0);
        //_protein_table_model_p->setIdentificationGroup(p_identification_group);
        //_p_proxy_model->setSourceModel(_protein_table_model_p);
        _ptm_table_model_p->setIdentificationGroup(p_identification_group);
        emit ptmIslandDataChanged();
        
        //ui->ptm_island_tableview->resizeRowToContents(_ptm_table_model_p->rowCount());
    }

    qDebug() << "PtmIslandListWindow::doIdentificationPtmGroupGrouped end";
}
