
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of PAPPSOms-tools.
*
*     PAPPSOms-tools is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms-tools is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#ifndef SPECTRUMPAINTER_H
#define SPECTRUMPAINTER_H

#include <QPainter>
#include <QPointF>
#include <pappsomspp/peptide/peptide.h>
#include <pappsomspp/spectrum/spectrum.h>
#include <pappsomspp/peptide/peptidefragmentionlistbase.h>
#include <pappsomspp/peptide/peptidenaturalisotopeaverage.h>
#include <pappsomspp/psm/peptidespectrummatch.h>
#include <pappsomspp/psm/peptideisotopespectrummatch.h>
#include <pappsomspp/spectrum/qualifiedspectrum.h>

using namespace pappso;

class SpectrumPainter
{
public:
    SpectrumPainter();
    ~SpectrumPainter();

    void setPeptideSp(const pappso::PeptideSp & peptide_sp);
    void setSpectrumSp(const pappso::SpectrumSp & spectrum_sp);
    void setParentIonCharge(unsigned int parent_ion_charge);
    void setIonList(const list< PeptideIon > & ion_list);
    void setPrecision(PrecisionP precision);
    void setPeptideFragmentIonList(const  std::vector<PeptideFragmentIonSp> & peptide_fragment_ion_list, const std::vector<unsigned int> & peptide_fragment_ion_charge_list);
    void setPeptideFragmentIonIsotopeList(const std::vector<PeptideNaturalIsotopeAverageSp> & peptide_fragment_ion_isotope_list, const std::vector<PeptideFragmentIonSp> & peptide_fragment_ion_list);
    
    
    void setIsotopeMassList(std::vector<pappso::PeptideNaturalIsotopeAverageSp> & isotopeMassList);

    mz getMzFromLocalPosX(pappso_double x) const;
    pappso_double getIntensityFromLocalPosY(pappso_double y) const;
    int getLocalPosYFromIntensity(pappso_double intensity) const;

    void paint(QPainter & painter, pappso_double width, pappso_double height);
    void setMarginLeft(pappso_double margin);
    void setFontPointSize(int point_size);
    void setMarginBottom(pappso_double margin);
    void setMarginTop(pappso_double margin);

    pappso_double getCanvasWidth() const {
        return _canvas_width;
    };
    pappso_double getMarginLeft() const {
        return _margin_left;
    };
    void setMinMz(mz mzX) {
        _min_mz = mzX;
    };
    void setMaxMz(mz mzX) {
        _max_mz = mzX;
    };
    void setMaxIntensity(pappso_double max_intensity) {
        _max_int = max_intensity;
    }
    void setQualifiedSpectrum(pappso::QualifiedSpectrum & spectrum);

private :
    PrecisionP _p_precision = pappso::Precision::getDaltonInstance(0.5);
    std::list< PeptideIon > _ion_list;
    unsigned int _parent_ion_charge=3;
    SpectrumSp _spectrum_sp;
    PeptideSp _peptide_sp;
    std::vector<PeptideFragmentIonSp> _peptide_fragment_ion_list;
    std::vector<unsigned int> _peptide_fragment_ion_charge_list;
    std::vector<PeptideNaturalIsotopeAverageSp> _peptide_fragment_ion_isotope_list;
    std::vector< PeptideNaturalIsotopeAverageSp > _isotope_mass_list;

private :

    bool _is_isotope = false;
    pappso_double _min_mz=0 ;
    pappso_double _max_mz=0 ;
    pappso_double _max_int = -1;
    pappso_double _canvas_height;
    pappso_double _canvas_width;
    pappso_double _spectrum_height = 500;
    pappso_double _spectrum_width = 1200;
    pappso_double _margin_top = 10;
    pappso_double _margin_bottom = 10;
    pappso_double _margin_left = 10;
    pappso_double _padding = 5;
    int _font_point_size = 12;
    unsigned int _ms_level;


private :
    pappso_double getX(pappso_double x) const;
    pappso_double getY(pappso_double x) const;
    bool peakInPsm(pappso::PeptideSpectrumMatch* p_psm, pappso::PeptideIsotopeSpectrumMatch* p_psm_isotope, mz mz);
    void convertPsmToSpectrum(Spectrum * spectrum_text_draw, pappso::PeptideSpectrumMatch* p_psm, pappso::PeptideIsotopeSpectrumMatch* p_psm_isotope);
};

#endif // SPECTRUMPAINTER_H

