
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of PAPPSOms-tools.
*
*     PAPPSOms-tools is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms-tools is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#include "qspectrumwidget.h"
#include <QStyleOption>
#include <pappsomspp/peptide/peptidefragmentionlistbase.h>
#include <pappsomspp/peptide/peptidestrparser.h>


QSpectrumWidget::QSpectrumWidget(QWidget *parent)
    : QWidget(parent)
{
    qDebug() << "QSpectrumWidget::QSpectrumWidget begin";
    //_ion_list = PeptideFragmentIonListBase::getCIDionList();

    //_peptide_sp = PeptideStrParser::parseString("AIADGSLLDLLR");

    //_spectrum_sp = readSpectrum("../../pappsomspp/test/data/peaklist_15046.mgf", 0, _zmax).makeSpectrumSp();

    unsigned int zmax=3;

    _spectrum_painter.setPeptideSp(Peptide("A").makePeptideSp());
    // _spectrum_painter.setSpectrumSp(Spectrum().makeSpectrumSp());

    _spectrum_painter.setParentIonCharge(zmax);
    _spectrum_painter.setIonList(PeptideFragmentIonListBase::getCIDionList());
    //_spectrum_painter.setPrecision(_p_precision);


    setMouseTracking(true);

    //SvgSpectrum svgspectrum(_peptide_sp, _spectrum_sp, _zmax, _precision, _ion_list);

    _spectrum_painter.setMarginLeft(60);
    _spectrum_painter.setMarginTop(15);
    _spectrum_painter.setMarginBottom(20);
    _spectrum_painter.setFontPointSize(10);

    qDebug() << "QSpectrumWidget::QSpectrumWidget end";

}
QSpectrumWidget::~QSpectrumWidget()
{

}

void QSpectrumWidget::setPrecision(pappso::PrecisionP p_precision) {
    qDebug() << "QSpectrumWidget::setPrecision";
    _spectrum_painter.setPrecision(p_precision);
    update();
}

void QSpectrumWidget::setPeptideSp(pappso::PeptideSp & peptide_sp) {
    _spectrum_painter.setPeptideSp(peptide_sp);
    update();
}
void QSpectrumWidget::setQualifiedSpectrum(pappso::QualifiedSpectrum spectrum) {

    _spectrum_painter.setQualifiedSpectrum(spectrum);
    update();

}

void QSpectrumWidget::paintEvent(QPaintEvent * /* event */)
{
    QPainter painter;
    painter.begin(this);
    painter.setRenderHint(QPainter::Antialiasing);
    paint(painter);
    painter.end();
}

void QSpectrumWidget::paint(QPainter &painter)
{
    //painter.drawLine(QLine(0, 35, 200, 35));
    _spectrum_painter.paint(painter, this->size().width(), this->size().height());
}

void QSpectrumWidget::setIsotopeMassList(std::vector<pappso::PeptideNaturalIsotopeAverageSp> & isotopeMassList) {
    _spectrum_painter.setIsotopeMassList(isotopeMassList);
    update();
}

