
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of PAPPSOms-tools.
*
*     PAPPSOms-tools is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms-tools is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef OVERLAYWIDGET_H
#define OVERLAYWIDGET_H
#include <QApplication>
#include <QMainWindow>
#include <QResizeEvent>
#include <QPainter>

#include "qspectrumwidget.h"

class OverlayWidget : public QWidget
{
public:
    explicit OverlayWidget(QWidget * parent = 0) : QWidget(parent) {
        if (parent) {
            parent->installEventFilter(this);
            raise();
        }
    }
protected:
    //! Catches resize and child events from the parent widget
    bool eventFilter(QObject * obj, QEvent * ev) {
        if (obj == parent()) {
            if (ev->type() == QEvent::Resize) {
                QResizeEvent * rev = static_cast<QResizeEvent*>(ev);
                resize(rev->size());
            }
            else if (ev->type() == QEvent::ChildAdded) {
                raise();
            }
        }
        return QWidget::eventFilter(obj, ev);
    }
    //! Tracks parent widget changes
    bool event(QEvent* ev) {
        if (ev->type() == QEvent::ParentAboutToChange) {
            if (parent()) parent()->removeEventFilter(this);
        }
        else if (ev->type() == QEvent::ParentChange) {
            if (parent()) {
                parent()->installEventFilter(this);
                raise();
            }
        }
        return QWidget::event(ev);
    }
};

class LoadingOverlay : public OverlayWidget
{
    Q_OBJECT
public:
    LoadingOverlay(QSpectrumWidget * parent) : OverlayWidget(parent) {
        // setAttribute(Qt::WA_TranslucentBackground);
        _p_spectrum_widget =parent;
	setMouseTracking(true);
    }
    void displayLoadingMessage();
    void hideLoadingMessage();
protected:
    void paintEvent(QPaintEvent *) override;
    void mouseReleaseEvent(QMouseEvent * event) override;
    void mousePressEvent(QMouseEvent * event) override;
    void mouseMoveEvent(QMouseEvent * event) override;
signals:
    void mzChanged(double mz);
private :
    void paintLoadingMessage(QPainter & painter);
    void paintUserSelectedZone(QPainter & painter);
private:
  bool _pressed = false;
    QSpectrumWidget * _p_spectrum_widget;
    mz _current_mouse_mz;
    bool _is_loading=false;

    std::pair<int, int> _first_point;
    std::pair<int, int> _second_point;

};

#endif // OVERLAYWIDGET_H
