/**
 * \filed core/msrun.h
 * \date 5/4/2017
 * \author Olivier Langella
 * \brief describes an MS run (chemical sample injected in a mass spectrometer)
 */


/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/


#ifndef MSRUN_H
#define MSRUN_H

#include <memory>
#include <QString>
#include "../utils/types.h"

class MsRun;
typedef std::shared_ptr<MsRun> MsRunSp;

class MsRun
{
public:
    MsRun(const QString & location);
    MsRun(const MsRun& other);
    ~MsRun();
    
    void setFilename(const QString filename);
    void setXmlId(const QString xmlid);
    
    const QString & getFilename() const;
    const QString & getSampleName() const;
    const QString & getXmlId() const;
    
    MzFormat getMzFormat() const;
    //void setMzFormat(MzFormat mz_format);
private :
    QString _xml_id;
    QString _location;
    QString _name;
    MzFormat _mz_format=MzFormat::mzXML;
};

#endif // MSRUN_H
