/**
 * \filed core/msrun.cpp
 * \date 5/4/2017
 * \author Olivier Langella
 * \brief describes an MS run (chemical sample injected in a mass spectrometer)
 */


/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <Olivier.Langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@u-psud.fr> - initial API and implementation
******************************************************************************/


#include "msrun.h"
#include <QFileInfo>

MsRun::MsRun(const QString & location) {
    _xml_id = location;
    _location = location;
    QFileInfo fileinfo(location);
    _name = fileinfo.baseName();
}

MsRun::MsRun(const MsRun& other) {
    _xml_id = other._xml_id;
    _location = other._location;
    _name = other._name;
}

MsRun::~MsRun() {
}


const QString & MsRun::getSampleName() const {
    return _name;
}

void MsRun::setFilename(const QString filename) {
    _location = filename;
    QFileInfo file_info(filename);
    QString extension = file_info.suffix();
    _mz_format = MzFormat::unknown;
    if (extension.toLower() == "mzxml") {
        _mz_format = MzFormat::mzXML;
    }
    else if (extension.toLower() == "mgf") {
        _mz_format = MzFormat::MGF;
    }
    else if (extension.toLower() == "mzml") {
        _mz_format = MzFormat::mzML;
    }
}
void MsRun::setXmlId(const QString xmlid) {
    _xml_id = xmlid;
}
const QString & MsRun::getXmlId() const {
    return _xml_id;
}
const QString & MsRun::getFilename() const {
    return _location;
}

MzFormat MsRun::getMzFormat() const {
    return _mz_format;
}

/*
void MsRun::setMzFormat(MzFormat mz_format) {
    _mz_format = mz_format;
}
*/
