#include "utils.h"

const QUrl Utils::getOlsUrl(QString psimod_accession) {

    QString iri(QString("http://purl.obolibrary.org/obo/%1").arg(psimod_accession.replace(":","_")));
    QUrl url(QString("http://www.ebi.ac.uk/ols/ontologies/mod/terms?iri=%1").arg(iri));
    return url;
}

const QString Utils::getXmlDouble(pappso::pappso_double number){
    return QString::number(number,'g',6);
}

const QString Utils::getDatabaseName(ExternalDatabase database) {
    QString database_name;
    switch (database) {
    case ExternalDatabase::AGI_LocusCode :
        database_name = "AGI_LocusCode";
        break;
    case ExternalDatabase::NCBI_gi :
        database_name = "NCBI_gi";
        break;

    case ExternalDatabase::SwissProt :
        database_name = "Swiss-Prot";
        break;
    case ExternalDatabase::TrEMBL :
        database_name = "TrEMBL";
        break;
    case ExternalDatabase::ref :
        database_name = "ref";
        break;
    }
    return database_name;
}
