/**
 * \file output/xpip.cpp
 * \date 13/4/2017
 * \author Olivier Langella
 * \brief XPIP writer
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "xpip.h"
#include <pappsomspp/pappsoexception.h>

Xpip::Xpip(const QString & out_filename)
{
    //_p_digestion_pipeline = p_digestion_pipeline;

    //_mzidentml = "http://psidev.info/psi/pi/mzIdentML/1.1";
    QString complete_out_filename = out_filename;
    _output_file = new QFile(complete_out_filename);

    if (_output_file->open(QIODevice::WriteOnly))
    {
        _output_stream = new QXmlStreamWriter();
        _output_stream->setDevice(_output_file);
    } else
    {
        throw pappso::PappsoException(QObject::tr("error : cannot open the XPIP output file : %1\n").arg(out_filename));
    }

    _output_stream->setAutoFormatting(true);
    _output_stream->writeStartDocument("1.0");


}

Xpip::~Xpip()
{
    delete _output_file;
    delete _output_stream;
}

void Xpip::close() {
    _output_stream->writeEndDocument();
    _output_file->close();
}

void Xpip::write(ProjectSp sp_project) {

    _sp_project = sp_project;
    if (_sp_project.get() == nullptr) {
        throw pappso::PappsoException(QObject::tr("Error writing XPIP :\n project is empty"));
    }

//<xtandem_pipeline version="3.3.5">
    _output_stream->writeStartElement("xpip");
    _output_stream->writeAttribute("version","4.0");
    //_output_stream->writeAttribute("creationDate", QDateTime::currentDateTime().toString( Qt::ISODate));
    _output_stream->writeNamespace("http://www.w3.org/2001/XMLSchema-instance","xsi");
    //_output_stream->writeNamespace("http://www.w3.org/2001/XMLSchema-instance","xsi");
    _output_stream->writeAttribute("xmlns","http://pappso.inra.fr/xsd/xpip/4.0");
    //xsi:schemaLocation="http://psidev.info/psi/pi/mzIdentML/1.1 http://www.psidev.info/files/mzIdentML1.1.0.xsd"
    _output_stream->writeAttribute("http://www.w3.org/2001/XMLSchema-instance","schemaLocation","http://pappso.inra.fr/xsd/xpip/4.0 http://pappso.inra.fr/xsd/xpip-4.0.xsd");

    
  //<information Data_Type="combi" match_number="6807"/>
   // _output_stream->writeStartElement("information");
  //  _output_stream->writeAttribute("Data_Type","combi");
   // _output_stream->writeEndElement();
    
  //<filter_params pep_evalue="0.01" prot_evalue="-2.0" pep_number="2" filter_to_all="false" database_filter="/gorgone/pappso/jouy/raw/2013_Orbitrap/2013_07_04_Chanat/contaminants_standarts.fasta"/>
    _output_stream->writeStartElement("filter_params");
    _output_stream->writeAttribute("pep_evalue","combi");
    _output_stream->writeAttribute("prot_evalue","combi");
    _output_stream->writeAttribute("pep_number","combi");
    _output_stream->writeAttribute("filter_to_all","combi");
    _output_stream->writeEndElement();
    
  <identifications>
    <identification>
      <modifs_list_mass>
        <modifs_mass modvalue="-18.01056"/>
        <modifs_mass modvalue="-17.02655"/>
        <modifs_mass modvalue="15.99491"/>
        <modifs_mass modvalue="42.01057"/>
        <modifs_mass modvalue="42.01056"/>
        <modifs_mass modvalue="57.02146"/>
      </modifs_list_mass>
      <samples>
        <sample value="20120906_balliau_extract_1_A01_urnb-1"/>
        <sample value="20120906_balliau_extract_1_A02_urzb-1"/>
      </samples>
    //<masschroq>
    // <rawdata><!-- time_values_dir="directory" to read retention time corrections-->
    _output_stream->writeStartElement("rawdata");
    _output_stream->writeComment("time_values_dir=\"directory\" to read retention time corrections");

    std::vector<MsRunSp> msrun_list = _sp_project.get()->getMsRunStore().getMsRunList();
    for (MsRunSp & msrun : msrun_list) {

        //<data_file id="samp0" format="mzxml" path="bsa1.mzXML" type="centroid" />
        _output_stream->writeStartElement("data_file");
        _output_stream->writeAttribute("id",msrun.get()->getXmlId());
        if(msrun.get()->getMzFormat() == MzFormat::mzXML) {
            _output_stream->writeAttribute("format","mzxml");
        }
        _output_stream->writeAttribute("path",msrun.get()->getFilename());
        _output_stream->writeAttribute("type","centroid");
        // <data_file id="samp1" format="mzxml" path="bsa2.mzXML" type="profile" />
        _output_stream->writeEndElement();
    }
    // <data_file id="samp2" format="mzml" path="/home/user/bsa3.mzml"      type="profile" />
//<data_file id="samp3" format="mzml" path="/home/user/bsa4.mzml"             type="profile" />
    // _output_stream.writeEndElement();
    //             </rawdata>
    _output_stream->writeEndElement();


    writeGroups();
    writeProteinList();
    writePeptideList();
    writeIsotopeLabelList();
    writeAlignments();
    writeQuantificationMethods();
    _output_stream->writeStartElement("quantification");
    writeQuantificationResults();
    writeQuantificationTraces();
    writeQuantify();
    _output_stream->writeEndElement();
}

