/**
 * \file /output/samplesheet.cpp
 * \date 8/5/2017
 * \author Olivier Langella
 * \brief ODS sample sheet
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "samplesheet.h"

SampleSheet::SampleSheet (OdsExport * p_ods_export, CalcWriterInterface * p_writer, const Project * p_project): _p_project(p_project) {
    _p_writer = p_writer;
    _p_ods_export = p_ods_export;
    p_writer->writeSheet("samples");

    writeHeaders();

    std::vector<IdentificationDataSourceSp> idrun_list = _p_project->getIdentificationDataSourceStore().getIdentificationDataSourceList();

    for (IdentificationDataSourceSp idrun_sp: idrun_list) {
        writeIdentificationDataSource(idrun_sp.get());
    }
}

void SampleSheet::writeHeaders()  {
    // MS sample name	X!tandem xml result file name	X!Tandem version
    //X!tandem xml model file name	total spectra used	total spectra assigned	assigned/used percent
    //total unique assigned	database file names	MS/MS data source file name	MS/MS data source file path
    //MS level 1	MS level 2	TIC mean in MS 1	TIC mean in MS 2	rt min	rt max


    _p_writer->writeLine();
    _p_writer->writeCell("sample ID");
    _p_writer->writeCell("sample");
    _p_writer->writeCell("MS run file");
    _p_writer->writeCell("Identification engine");
    _p_writer->writeCell("Identification engine version");
    _p_writer->writeCell("Identification result file");
    _p_writer->writeCell("Identification fasta files");
    _p_writer->writeCell("X!Tandem parameters");


}

void SampleSheet::writeIdentificationDataSource(IdentificationDataSource * p_ident_data_source) {
    _p_writer->writeLine();
    _p_writer->writeCell(p_ident_data_source->getMsRunSp().get()->getXmlId());
    _p_writer->writeCell(p_ident_data_source->getMsRunSp().get()->getSampleName());
    _p_writer->writeCell(p_ident_data_source->getMsRunSp().get()->getFilename());
    _p_writer->writeCell(p_ident_data_source->getIdentificationEngineName());
    _p_writer->writeCell(p_ident_data_source->getIdentificationEngineVersion());
    _p_writer->writeCell(p_ident_data_source->getResourceName());

    QStringList fasta_files;
    for (FastaFileSp fasta_file:p_ident_data_source->getFastaFileList()) {
        fasta_files << fasta_file.get()->getAbsoluteFilePath();
    }
    _p_writer->writeCell(fasta_files.join(" "));

    _p_writer->writeCell(p_ident_data_source->getIdentificationEngineParam(IdentificationEngineParam::tandem_param).toString());

}
