/**
 * \file output/ods/odsexport.cpp
 * \date 11/4/2017
 * \author Olivier Langella
 * \brief ODS export
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "odsexport.h"
#include "simplesheet.h"
#include "proteinsheet.h"
#include "peptidesheet.h"
#include "spectrasheet.h"
#include "peptidepossheet.h"
#include "comparspectrasheet.h"
#include "comparspecificspectrasheet.h"
#include "infosheet.h"
#include "samplesheet.h"
#include "groupingsheet.h"
#include <QSettings>

OdsExport::OdsExport(const Project * project):_p_project(project) {
}
void OdsExport::setEvenOrOddStyle(unsigned int number, CalcWriterInterface * p_writer) {

    if (number % 2) { /* x is odd */
        p_writer->setTableCellStyleRef(_odd_style);

    } else {
        p_writer->setTableCellStyleRef(_even_style);
    }

}

void OdsExport::write(CalcWriterInterface * p_writer) {
    QSettings settings;

    OdsTableCellStyle style;
    style.setBackgroundColor(QColor("red"));
    _odd_style = p_writer->getTableCellStyleRef(style);
    style.setBackgroundColor(QColor("orange"));
    _even_style = p_writer->getTableCellStyleRef(style);

    InfoSheet(this, p_writer, _p_project);
    if (settings.value("export_ods/groups", "true").toBool()) {
        GroupingSheet(this, p_writer, _p_project);
    }
    if (settings.value("export_ods/simple", "false").toBool()) {
        SimpleSheet(p_writer, _p_project);
    }
    if (settings.value("export_ods/proteins", "true").toBool()) {
        ProteinSheet(this, p_writer, _p_project);
    }
    if (settings.value("export_ods/peptides", "true").toBool()) {
        PeptideSheet(this, p_writer, _p_project);
    }
    if (settings.value("export_ods/spectra", "true").toBool()) {
        SpectraSheet(this, p_writer, _p_project);
    }
    if (settings.value("export_ods/peptidepos", "true").toBool()) {
        PeptidePosSheet(this, p_writer, _p_project);
    }
    if (settings.value("export_ods/comparspectra", "true").toBool()) {
        ComparSpectraSheet(this, p_writer, _p_project).writeSheet();
    }
    if (settings.value("export_ods/comparspecificspectra", "true").toBool()) {
        ComparSpecificSpectraSheet(this, p_writer, _p_project).writeSheet();
    }
    if (settings.value("export_ods/comparuniquesequence", "true").toBool()) {
        ComparSequenceSheet(this, p_writer, _p_project).writeSheet();
    }
    if (settings.value("export_ods/comparspecificuniquesequence", "true").toBool()) {
        ComparSpecificSequenceSheet(this, p_writer, _p_project).writeSheet();
    }
    if (settings.value("export_ods/comparpai", "true").toBool()) {
        ComparPaiSheet(this, p_writer, _p_project).writeSheet();
    }
    if (settings.value("export_ods/comparempai", "true").toBool()) {
        ComparEmpaiSheet(this, p_writer, _p_project).writeSheet();
    }
    if (settings.value("export_ods/samples", "true").toBool()) {
        SampleSheet(this, p_writer, _p_project);
    }
}
