/**
 * \file output/ods/infosheet.cpp
 * \date 30/4/2017
 * \author Olivier Langella
 * \brief ODS info sheet
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "infosheet.h"
#include "../../config.h"
#include <QDebug>


InfoSheet::InfoSheet (OdsExport * p_ods_export, CalcWriterInterface * p_writer, const Project * p_project): _p_project(p_project) {
    _p_ods_export = p_ods_export;
    _p_writer = p_writer;
    p_writer->writeSheet("X!TandemPipeline informations");

    p_writer->writeCell("X!TandemPipeline version :");
    p_writer->writeLine();
    p_writer->writeCell(QString("%1").arg(XTPCPP_VERSION));

    p_writer->writeLine();
    p_writer->writeLine();
    p_writer->writeCell("X!TandemPipeline filters :");
    p_writer->writeLine();
    AutomaticFilterParameters filter_param = p_project->getAutomaticFilterParameters();

    p_writer->writeCell("Mode");
    if (p_project->isCombineMode()) {
        p_writer->writeCell("combine");
    }
    else {
        p_writer->writeCell("individual");
    }
    p_writer->writeLine();
    p_writer->writeCell("Maximum peptide Evalue");
    p_writer->writeCell(filter_param.getFilterPeptideEvalue());
    p_writer->writeLine();
    p_writer->writeCell("Minimum number of peptides per protein");
    p_writer->writeCell(filter_param.getFilterMinimumPeptidePerMatch());
    p_writer->writeLine();
    p_writer->writeCell("Overall samples");
    p_writer->writeCell(filter_param.getFilterCrossSamplePeptideNumber());
    p_writer->writeLine();
    p_writer->writeCell("Maximum protein Evalue");
    p_writer->writeCell(filter_param.getFilterProteinEvalue());
    p_writer->writeLine();
}

