/**
 * \file output/ods/comparspectrasheet.cpp
 * \date 30/4/2017
 * \author Olivier Langella
 * \brief ODS compar spectra sheet
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "comparspectrasheet.h"

#include <tuple>
#include <pappsomspp/utils.h>
#include <QDebug>


ComparSpectraSheet::ComparSpectraSheet (OdsExport * p_ods_export, CalcWriterInterface * p_writer, const Project * p_project): ComparBaseSheet(p_ods_export, p_writer, p_project) {
    _title_sheet =  "compar spectra";
}

void ComparSpectraSheet::writeComparValue(const ProteinMatch * p_protein_match, ValidationState state, const MsRun * p_msrun) {
    qDebug() << "ComparSpectraSheet::writeComparValue begin";
    _p_writer->writeCell(p_protein_match->countSampleScan(state, p_msrun));
    qDebug() << "ComparSpectraSheet::writeComparValue end";
}


ComparSequenceSheet::ComparSequenceSheet (OdsExport * p_ods_export, CalcWriterInterface * p_writer, const Project * p_project): ComparBaseSheet(p_ods_export, p_writer, p_project) {
    _title_sheet =  "compar unique sequence";
}

void ComparSequenceSheet::writeComparValue(const ProteinMatch * p_protein_match, ValidationState state, const MsRun * p_msrun) {
    qDebug() << "ComparSequenceSheet::writeComparValue begin";
    _p_writer->writeCell((unsigned int) p_protein_match->countSequenceLi(state, p_msrun));
    qDebug() << "ComparSequenceSheet::writeComparValue end";
}

ComparPaiSheet::ComparPaiSheet (OdsExport * p_ods_export, CalcWriterInterface * p_writer, const Project * p_project): ComparBaseSheet(p_ods_export, p_writer, p_project) {
    _title_sheet =  "compar PAI";
}

void ComparPaiSheet::writeComparValue(const ProteinMatch * p_protein_match, ValidationState state, const MsRun * p_msrun) {
    qDebug() << "ComparPaiSheet::writeComparValue begin";
    _p_writer->writeCell(p_protein_match->getPAI(p_msrun));
    qDebug() << "ComparPaiSheet::writeComparValue end";
}

ComparEmpaiSheet::ComparEmpaiSheet (OdsExport * p_ods_export, CalcWriterInterface * p_writer, const Project * p_project): ComparBaseSheet(p_ods_export, p_writer, p_project) {
    _title_sheet =  "compar emPAI";
}

void ComparEmpaiSheet::writeComparValue(const ProteinMatch * p_protein_match, ValidationState state, const MsRun * p_msrun) {
    qDebug() << "ComparEmpaiSheet::writeComparValue begin";
    _p_writer->writeCell(p_protein_match->getEmPAI(p_msrun));
    qDebug() << "ComparEmpaiSheet::writeComparValue end";
}
