/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of XTandemPipeline.
 *
 *     XTandemPipeline is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     XTandemPipeline is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with XTandemPipeline.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr>
 ******************************************************************************/

package fr.inra.pappso.xtandempipeline.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import org.apache.log4j.Logger;

import fr.inra.moulon.proticport.model.exceptions.ProticPortException;
import fr.inra.pappso.xtandempipeline.Utils;
import fr.inra.pappso.xtandempipeline.XtandemPipelineSession;
import fr.inra.pappso.xtandempipeline.MsException.MSMSException;
import fr.inra.pappso.xtandempipeline.class_msms.Identification;
import fr.inra.pappso.xtandempipeline.class_msms.Modifs;
import fr.inra.pappso.xtandempipeline.class_msms.ModifsList;
import fr.inra.pappso.xtandempipeline.class_msms.MsRun;
import fr.inra.pappso.xtandempipeline.class_msms.Protein;
import fr.inra.pappso.xtandempipeline.class_msms.GroupingProtein.PeptideMass;
import fr.inra.pappso.xtandempipeline.class_msms.GroupingProtein.PeptideMassSet;
import fr.inra.pappso.xtandempipeline.class_msms.MapDb.Peptide;
import fr.inra.pappso.xtandempipeline.grouping.Group;
import fr.inra.pappso.xtandempipeline.grouping.HashSampleScanSet;
import fr.inra.pappso.xtandempipeline.grouping.HashSampleScanSetPhospho;
import fr.inra.pappso.xtandempipeline.grouping.HashSampleScanSetProt;
import fr.inra.pappso.xtandempipeline.grouping.SubGroup;
import fr.inra.pappso.xtandempipeline.grouping.SubGroupSet;
import fr.inra.pappso.xtandempipeline.grouping.interfaces.GrpPeptide;

public class MassChroqPrmWriter {
	private static final Logger logger = Logger
			.getLogger(MassChroqPrmWriter.class);

	static String namespaceURI = "http://sashimi.sourceforge.net/schema_revision/mzXML_2.0";
	static String xmlnsxsi = "http://www.w3.org/2001/XMLSchema-instance";
	static String xsischemaLocation = "http://sashimi.sourceforge.net/schema_revision/mzXML_2.0 http://sashimi.sourceforge.net/schema_revision/mzXML_2.0/mzXML_idx_2.0.xsd";

	protected XMLStreamWriter writer;

	private Hashtable<MsRun, String> sample2xmlId;
	private String groupe_id;

	private String xtpExperimentType;

	private Hashtable<String, String> accession2xmlid;

	MassChroqPrmWriter(XMLStreamWriter writer) throws ProticPortException {
		this.sample2xmlId = new Hashtable<MsRun, String>();
		this.groupe_id = "G1";
		this.writer = writer;

	}

	public void write(ModifsList isotopic_mods, Identification ident)
			throws XMLStreamException, ProticPortException {
		logger.debug("write begin");
		long duracel = System.currentTimeMillis();

		xtpExperimentType = XtandemPipelineSession.getInstance()
				.getDataTypeBase().getType();

		if (this.xtpExperimentType.equals("phospho")) {
			accession2xmlid = new Hashtable<String, String>();
		}

		// writer.setPrefix("xsi", xmlnsxsi);
		// writer.setDefaultNamespace(namespaceURI);
		writer.writeStartElement("masschroqprm");
		// writer.writeNamespace("xsi", xmlnsxsi);
		// writer.writeDefaultNamespace(namespaceURI);

		// writer.writeAttribute(xmlnsxsi, "schemaLocation", xsischemaLocation);

		this.writePeptides(ident);

		logger.info("Duration creating MassChroQml xml document: "
				+ (System.currentTimeMillis() - duracel) + " ms");
		// masschroq
		writer.writeEndElement();

	}

	private void writePeptides(Identification ident) {
		logger.debug("write begin");
		/*
		 *
		 *
		 * <peptide seq="TCVADESHAGCEK" id="p1"> <psimod at="2"
		 * acc="MOD:00397"/> <psimod at="11" acc="MOD:00397"/> </peptide>
		 */
		try {
			/*
			 *
<parameters>
<parentIonMassTolerance>
	<daltonPrecision value="1.5"/>
</parentIonMassTolerance>
<fragmentIonMassTolerance>
	<daltonPrecision value="0.02"/>
</fragmentIonMassTolerance>
</parameters>
			 */
			writer.writeStartElement("parameters");
			writer.writeStartElement("parentIonMassTolerance");
			writer.writeComment("choose dalton or ppm mass precision to select parent ions based on the precursor mass of each MS/MS spectrum");
			writer.writeStartElement("ppmPrecision");
			writer.writeAttribute("value", "10");
			writer.writeEndElement();
			writer.writeEndElement();
			writer.writeStartElement("fragmentIonMassTolerance");
			writer.writeComment("choose dalton or ppm mass precision to MS/MS fragment ion observed mass with theoretical mass");
			writer.writeStartElement("daltonPrecision");
			writer.writeAttribute("value", "0.02");
			writer.writeEndElement();
			writer.writeEndElement();
			writer.writeEndElement();

			writer.writeStartElement("peptideList");

			for (Group group : ident.getGrouping().getGroupList()) {
				PeptideMassSet pepMassSet = new PeptideMassSet();

				logger.debug("pepMassSet size : " + pepMassSet.size());

				logger.debug("pepMassSet numbering");
				pepMassSet.numberingGetPepMass2PeptideList(group);

				// iterated current pepid to write buffer peptide element
				for (PeptideMass pepMass : pepMassSet) {
					writer.writeStartElement("peptide");
					writer.writeAttribute("id",
							Utils.getPappsoPeptideMassId(group, pepMass));
					Peptide bestPeptide = pepMass.getBestEvaluePeptide();
					writer.writeAttribute("seq", bestPeptide.getSequence());

					ArrayList<Modifs> arrModif = bestPeptide.get_Modifs();
					for (Modifs modif : arrModif) {
						writer.writeStartElement("psimod");
						writer.writeAttribute("at", "" + modif.get_posi());

						writer.writeAttribute("acc", ""
								+ modif.getPsiMod().getAccession());
						writer.writeEndElement();
					}
					writer.writeEndElement();
				}

			}
			writer.writeEndElement();
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		logger.debug("write end");
	}

}
