/**
 * \file /gui/workerthread.h
 * \date 8/5/2017
 * \author Olivier Langella
 * \brief worker thread
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef WORKERTHREAD_H
#define WORKERTHREAD_H

#include <QThread>
#include <QCloseEvent>
#include "../core/automaticfilterparameters.h"
#include "../core/project.h"
#include "../utils/workmonitor.h"

class MainWindow;
class ProjectWindow;

class WorkerThread : public QObject
{
    Q_OBJECT

public:

    WorkerThread(MainWindow * parent);
    WorkerThread(ProjectWindow * parent);
    ~WorkerThread();


protected:

    void closeEvent(QCloseEvent *event);

public slots:
    void doXpipFileLoad(QString filename);
    void doLoadingResults(bool is_individual, AutomaticFilterParameters param, QStringList file_list);
    void doWritingOdsFile(QString filename, ProjectSp project_sp);
    void doWritingMassChroqFile(QString filename, ProjectSp project_sp);
    void doWritingProticFile(QString filename, ProjectSp project_sp);
    void doGrouping(ProjectSp project_sp);
    void doGroupingOnIdentification(IdentificationGroup * p_identification_group, GroupingType grouping_type);
    void doPtmGroupingOnIdentification(IdentificationGroup * p_identification_group);


signals:
    void loadingMessage(QString message);
    void projectReady(ProjectSp project_sp);
    void projectNotReady(QString error);
    void groupingFinished();
    void groupingOnIdentificationFinished(IdentificationGroup * p_identification_group);
    void ptmGroupingOnIdentificationFinished(IdentificationGroup * p_identification_group);
    void operationFinished();
    void operationFailed(QString error);
    
private:
    WorkMonitor * _p_work_monitor;
};

#endif // WORKERTHREAD_H
