
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PROTEINTABLEMODEL_H
#define PROTEINTABLEMODEL_H

#include <QAbstractTableModel>
#include "../../core/project.h"


/** \def ProteinListColumn list of available fields to display in protein list
 *
 */

enum class ProteinListColumn {
     checked, ///< manual checked
     protein_grouping_id, ///< protein grouping id
     accession, ///< accession
     description, ///< protein description
     log_evalue, ///< log(Evalue)
     evalue, ///< Evalue
     spectrum, ///< spectrum count
     specific_spectrum, ///< specific spectrum count
     sequence, ///< unique sequence count
     specific_sequence, ///< specific unique sequence
     coverage, ///< protein coverage
     pai, ///< PAI
     empai, ///< emPAI
};

class ProteinListWindow;

class ProteinTableModel: public QAbstractTableModel
{
    Q_OBJECT
public:
    ProteinTableModel(ProteinListWindow * p_protein_list_window);
    virtual int rowCount(const QModelIndex &parent = QModelIndex()) const override;
    virtual int columnCount(const QModelIndex &parent = QModelIndex()) const override;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const override;
    virtual QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const override;
    
    static const QString getTitle(ProteinListColumn column);
    static const QString getDescription(ProteinListColumn column);


    void setIdentificationGroup(IdentificationGroup * p_identification_group);
    IdentificationGroup * getIdentificationGroup();
    using columnMap = std::int8_t[20];
    
public slots:
    void onProteinDataChanged();
private :
      static const QString getTitle(std::int8_t column);
    static const QString getDescription(std::int8_t column);

    void refresh();
private :
    IdentificationGroup * _p_identification_group = nullptr;
    ProteinListWindow * _p_protein_list_window;
    QStringList _columns;
    
    static columnMap _column_assignment;
};

#endif // PROTEINTABLEMODEL_H
