
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef PROTEINLISTWINDOW_H
#define PROTEINLISTWINDOW_H


#include <QMainWindow>
#include "proteintablemodel.h"
#include "proteintableproxymodel.h"

class ProjectWindow;

//http://doc.qt.io/qt-4.8/qt-itemviews-chart-mainwindow-cpp.html
namespace Ui {
class ProteinView;
}

class ProteinListWindow: public QMainWindow {
    Q_OBJECT

    friend class ProteinTableModel;
    friend class ProteinTableProxyModel;
public:

    explicit ProteinListWindow(ProjectWindow * parent = 0);
    ~ProteinListWindow();
    void setIdentificationGroup(IdentificationGroup * p_identification_group);

    void edited();

public slots:
    void doFocusReceived(bool has_focus);
    void doIdentificationGroupGrouped(IdentificationGroup * p_identification_group);
    //void peptideEdited(QString peptideStr);
    // void setColor(const QColor &color);
    // void setShape(Shape shape);
signals:
    void identificationGroupEdited(IdentificationGroup * p_identification_group);
    void proteinDataChanged();


protected slots:
    void doNotValidHide(bool hide);
    void doNotCheckedHide(bool hide);
    void doNotGroupedHide(bool hide);
    void doProxyLayoutChanged();
    void showContextMenu(const QPoint &);
    void showEvalueColumn(bool show);
    void showAccessionColumn(bool show);
    void updateStatusBar();
    void onProteinSearchEdit(QString protein_search_string);
    void doSearchOn(QString search_on);

protected :
    void askProteinDetailView(ProteinMatch * p_protein_match);
    void askPeptideListView(ProteinMatch * p_protein_match);



private:
    IdentificationGroup * _p_identification_group=nullptr;
    Ui::ProteinView *ui;
    ProteinTableModel * _protein_table_model_p = nullptr;
    ProteinTableProxyModel * _p_proxy_model = nullptr;
    ProjectWindow * _project_window;
    bool _display_evalue = true;
    bool _display_accession = true;

};

#endif // PROTEINLISTWINDOW_H
