
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef AUTOMATICFILTERWIDGET_H
#define AUTOMATICFILTERWIDGET_H

#include "../../../core/automaticfilterparameters.h"
#include <QWidget>


namespace Ui {
class AutomaticFilterWidget;
}

class AutomaticFilterWidget : public QWidget
{
    Q_OBJECT

public:
    explicit AutomaticFilterWidget(QWidget * parent);
    ~AutomaticFilterWidget();

    void setAutomaticFilterParameters(const AutomaticFilterParameters & params);
    void hideButton();
    AutomaticFilterParameters getAutomaticFilterParameters() const;

public slots:
    void doPeptideEvalue(double evalue);
    void doProteinEvalue(double evalue);
    void doProteinLogEvalue(double evalue);
    void doPeptideNumber(int number);
    void doCrossSample(bool is_cross_sample);
    void doSetParameters();

signals:
    void automaticFilterParametersChanged(AutomaticFilterParameters parameters);

private:
    Ui::AutomaticFilterWidget *ui;
    bool _signal = true;

    AutomaticFilterParameters _parameters;

};

#endif // AUTOMATICFILTERWIDGET_H
