
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "automaticfilterwidget.h"

#include "../projectwindow.h"
#include "ui_automatic_filter_widget.h"
#include <QDebug>
#include <cmath>


AutomaticFilterWidget::AutomaticFilterWidget(QWidget * parent):
    QWidget(parent),
    ui(new Ui::AutomaticFilterWidget)
{
    qDebug() << "AutomaticFilterWidget::AutomaticFilterWidget begin";
    ui->setupUi(this);

    qDebug() << "AutomaticFilterWidget::AutomaticFilterWidget end";
}

AutomaticFilterWidget::~AutomaticFilterWidget()
{
    delete ui;
}


AutomaticFilterParameters AutomaticFilterWidget::getAutomaticFilterParameters() const {
    return _parameters;
}

void AutomaticFilterWidget::hideButton() {
    qDebug() << "AutomaticFilterWidget::hideButton begin ";
    ui->set_param_button->setVisible(false);
    qDebug() << "AutomaticFilterWidget::hideButton end ";
}
void AutomaticFilterWidget::setAutomaticFilterParameters(const AutomaticFilterParameters & params) {
    qDebug() << "AutomaticFilterWidget::setAutomaticFilterParameters begin ";
    _parameters = params;

    ui->peptide_evalue_spinbox->setValue(_parameters.getFilterPeptideEvalue());
    ui->protein_evalue_spinbox->setValue(_parameters.getFilterProteinEvalue());
    ui->peptide_number_spinbox->setValue(_parameters.getFilterMinimumPeptidePerMatch());
    //ui->protein_evalue_log_spinbox->setValue(std::log(_parameters.getFilterProteinEvalue()));
    ui->cross_sample_checkbox->setCheckState(Qt::Unchecked);
    if (_parameters.getFilterCrossSamplePeptideNumber()) ui->cross_sample_checkbox->setCheckState(Qt::Checked);
    qDebug() << "AutomaticFilterWidget::setAutomaticFilterParameters end ";
}

void AutomaticFilterWidget::doCrossSample(bool is_cross_sample) {
    _parameters.setFilterCrossSamplePeptideNumber(is_cross_sample);
}
void AutomaticFilterWidget::doPeptideEvalue(double evalue) {
    _parameters.setFilterPeptideEvalue(evalue);
}
void AutomaticFilterWidget::doProteinEvalue(double evalue) {
    if (_signal) {
        _parameters.setFilterProteinEvalue(evalue);
        _signal = false;
        ui->protein_evalue_log_spinbox->setValue(std::log10(_parameters.getFilterProteinEvalue()));
    }
    else {
        _signal = true;
    }
}
void AutomaticFilterWidget::doProteinLogEvalue(double evalue) {
    if (_signal) {
        _parameters.setFilterProteinEvalue(std::pow(10, evalue));
        _signal = false;
        ui->protein_evalue_spinbox->setValue(_parameters.getFilterProteinEvalue());
    }
    else {
        _signal = true;
    }
}
void AutomaticFilterWidget::doPeptideNumber(int number) {
    _parameters.setFilterMinimumPeptidePerMatch((unsigned int) number);
}
void AutomaticFilterWidget::doSetParameters() {
    emit automaticFilterParametersChanged(_parameters);
}
