
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include <QDebug>
#include <pappsomspp/pappsoexception.h>
#include "peptidetableproxymodel.h"
#include "peptidetablemodel.h"
#include "peptidelistwindow.h"
#include "../project_view/projectwindow.h"

PeptideTableProxyModel::PeptideTableProxyModel(PeptideListWindow * p_peptide_list_window, PeptideTableModel * peptide_table_model_p): QSortFilterProxyModel(peptide_table_model_p)
{
    _peptide_table_model_p = peptide_table_model_p;
    _p_peptide_list_window = p_peptide_list_window;
}

bool PeptideTableProxyModel::filterAcceptsColumn(int source_column, const QModelIndex & source_parent) const {
    if (source_column == 8) {
        if (_p_peptide_list_window->getProjectWindow()->getProjectP()->getLabelingMethodSp().get() == nullptr) {
            return false;
        }
    }
    return true;
}
bool PeptideTableProxyModel::filterAcceptsRow(int source_row,
        const QModelIndex &source_parent) const {
    try {
        qDebug() << "PeptideTableProxyModel::filterAcceptsRow begin " << source_row;
        PeptideMatch * peptide_match = _peptide_table_model_p->getProteinMatch()->getPeptideMatchList().at(source_row);
        qDebug() << "PeptideTableProxyModel::filterAcceptsRow protein_match " << source_row;

        if (!_peptide_search_string.isEmpty()) {
            if (_search_on == "peptide") {
                if (!peptide_match->getPeptideXtpSp().get()->getSequence().contains(_peptide_search_string)) {
                    return false;
                }
            }
            else if (_search_on == "sample") {
                if (!peptide_match->getMsRunP()->getSampleName().contains(_peptide_search_string)) {
                    return false;
                }
            } else if (_search_on == "subgroup") {
                if (peptide_match->getValidationState() != ValidationState::grouped) {
                    return false;
                }
                unsigned int subgroup = _peptide_search_string.toUInt();
                return false;
            } else if (_search_on == "modification") {
                return false;
            }
        }

        qDebug() << "PeptideTableProxyModel::filterAcceptsRow valid ";
        if (_hide_not_valid) {
            if (! peptide_match->isValid()) {
                return false;
            }
        }
        qDebug() << "PeptideTableProxyModel::filterAcceptsRow checked ";
        if (_hide_not_checked) {
            if (! peptide_match->isChecked()) {
                return false;
            }
        }

        qDebug() << "PeptideTableProxyModel::filterAcceptsRow grouped ";
        if (_hide_not_grouped) {
            if (! peptide_match->isGrouped()) {
                return false;
            }

        }
        return true;
    }

    catch (pappso::PappsoException exception_pappso) {
        //QMessageBox::warning(this,
        //                     tr("Error in ProteinTableModel::acceptRow :"), exception_pappso.qwhat());
        qDebug() << "Error in PeptideTableProxyModel::acceptRow :" << exception_pappso.qwhat();
    }
    catch (std::exception exception_std) {
        //QMessageBox::warning(this,
        //                    tr("Error in ProteinTableModel::acceptRow :"), exception_std.what());
        qDebug() << "Error in PeptideTableProxyModel::acceptRow :" << exception_std.what();
    }

    return true;

    //return true;
}



void PeptideTableProxyModel::onTableClicked(const QModelIndex &index)
{
    qDebug() << "PeptideTableProxyModel::onTableClicked begin " << index.row();
    qDebug() << "PeptideTableProxyModel::onTableClicked begin " << this->mapToSource(index).row();

    //_protein_table_model_p->onTableClicked(this->mapToSource(index));
    QModelIndex source_index(this->mapToSource(index));
    int row = source_index.row();
    int col = source_index.column();
    PeptideMatch * peptide_match = _peptide_table_model_p->getProteinMatch()->getPeptideMatchList().at(row);
    if (col == 0) //add a checkbox to cell(1,0)
    {

        if ( peptide_match->isChecked()) {
            peptide_match->setChecked(false);
        }
        else {
            peptide_match->setChecked(true);
        }
        _p_peptide_list_window->edited();
    }
    else {
        _p_peptide_list_window->askPeptideDetailView(peptide_match);
    }
    qDebug() << "PeptideTableProxyModel::onTableClicked end " << index.row();

}

bool PeptideTableProxyModel::lessThan(const QModelIndex & left, const QModelIndex & right) const {
    QVariant leftData = sourceModel()->data(left);
    QVariant rightData = sourceModel()->data(right);
    if (leftData.type() == QVariant::UInt) {
        return leftData.toUInt() < rightData.toUInt();
    }
    if (leftData.type() == QVariant::UInt) {
        return leftData.toUInt() < rightData.toUInt();
    }
    if (leftData.type() == QVariant::Double) {
        return leftData.toDouble() < rightData.toDouble();
    }
    return leftData.toString() < rightData.toString();
}


QVariant PeptideTableProxyModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if (role == Qt::DisplayRole)
    {
        if (orientation == Qt::Horizontal) {
            if (_p_peptide_list_window->getProjectWindow()->getProjectP()->getLabelingMethodSp().get() == nullptr) {
                if (section > 7) {
                    section = section+1;
                }
                return sourceModel()->headerData(section, orientation, role);
        }
            else {
                return sourceModel()->headerData(section, orientation, role);
            }
        }
    }
    return QVariant();
}

void PeptideTableProxyModel::hideNotValid(bool hide) {
    _hide_not_valid = hide;
}

void PeptideTableProxyModel::hideNotChecked(bool hide) {
    qDebug() << "PeptideTableProxyModel::hideNotChecked begin ";
    _hide_not_checked = hide;
    qDebug() << "PeptideTableProxyModel::hideNotChecked end ";
}
void PeptideTableProxyModel::hideNotGrouped(bool hide) {
    _hide_not_grouped = hide;
}

void PeptideTableProxyModel::setSearchOn(QString search_on) {
    _search_on = search_on;
}
void PeptideTableProxyModel::setPeptideSearchString(QString peptide_search_string) {
    _peptide_search_string = peptide_search_string;
}
