
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "peptidetablemodel.h"

#include <QDebug>
#include <QColor>
#include <pappsomspp/grouping/grppeptide.h>
#include "../../core/labeling/label.h"


PeptideTableModel::PeptideTableModel(QObject *parent)
    :QAbstractTableModel(parent)
{

    //ui->tableView->show();
    // QModelIndex topLeft = createIndex(0,0);
    //emit a signal to make the view reread identified data
    //emit dataChanged(topLeft, topLeft);
}


void PeptideTableModel::setProteinMatch(ProteinMatch * p_protein_match) {
    qDebug() << "PeptideTableModel::setProteinMatch begin " ;

    beginResetModel();
    _p_protein_match = p_protein_match;
    endResetModel();
    //QModelIndex topLeft = createIndex(0,0);
    //QModelIndex bottomRight = createIndex(rowCount(),columnCount());


    //emit dataChanged(topLeft, topLeft);
    //emit headerDataChanged(Qt::Horizontal, 0,3);
    qDebug() << "PeptideTableModel::setProteinMatch end " ;
}

ProteinMatch * PeptideTableModel::getProteinMatch() {
    return _p_protein_match;
}
int PeptideTableModel::rowCount(const QModelIndex &parent ) const {
    if (_p_protein_match != nullptr) {
        //qDebug() << "PeptideTableModel::rowCount(const QModelIndex &parent ) " << _p_protein_match->getPeptideMatchList().size();
        return (int) _p_protein_match->getPeptideMatchList().size();
    }
    return 0;
}
int PeptideTableModel::columnCount(const QModelIndex &parent ) const {
    return 17;
}
QVariant PeptideTableModel::headerData(int section, Qt::Orientation orientation, int role) const
{
    if (role == Qt::DisplayRole)
    {
        if (orientation == Qt::Horizontal) {
            switch (section)
            {
            case 0:
                return QString("checked");
            case 1:
                return QString("peptide ID");
            case 2:
                return QString("sample");
            case 3:
                return QString("scan");
            case 4:
                return QString("RT");
            case 5:
                return QString("charge");
            case 6:
                return QString("sequence");
            case 7:
                return QString("modifs");
            case 8:
                return QString("label");
            case 9:
                return QString("start");
            case 10:
                return QString("length");
            case 11:
                return QString("used");
            case 12:
                return QString("subgroups");
            case 13:
                return QString("Evalue");
            case 14:
                return QString("theoretical MH+");
            case 15:
                return QString("delta MH+");
            case 16:
                return QString("hyperscore");
            }
        }
    }
    return QVariant();
}
QVariant PeptideTableModel::data(const QModelIndex &index, int role ) const {
    // generate a log message when this method gets called
    int row = index.row();
    int col = index.column();
    //qDebug() << QString("row %1, col%2, role %3")
    //         .arg(row).arg(col).arg(role);

    switch(role) {
    case Qt::CheckStateRole:

        if (col == 0) //add a checkbox to cell(1,0)
        {
            if ( _p_protein_match->getPeptideMatchList().at(row)->isChecked()) {
                return Qt::Checked;
            }
            else {
                return Qt::Unchecked;
            }
        }
        break;
    case Qt::BackgroundRole:
        if (_p_protein_match->getPeptideMatchList().at(row)->isValid() == false)
        {
            return QVariant(QColor("grey"));
        }
        break;
    case Qt::DisplayRole:
        if (_p_protein_match == nullptr) {
        }
        else {

            if (col == 0) {
                return QVariant();
            }
            if (col == 1) {
                pappso::GrpPeptide * p_grp_peptide = _p_protein_match->getPeptideMatchList().at(row)->getGrpPeptideSp().get();
                if (p_grp_peptide != nullptr) return p_grp_peptide->getGroupingId();
                return QVariant();
            }
            if (col == 2) {
                return _p_protein_match->getPeptideMatchList().at(row)->getIdentificationDataSource()->getSampleName();
            }
            if (col == 3) {
                return QVariant ((quint32) _p_protein_match->getPeptideMatchList().at(row)->getScan());
            }
            if (col == 4) {
                return QVariant ((qreal) _p_protein_match->getPeptideMatchList().at(row)->getRetentionTime());
            }
            if (col == 5) {
                return QVariant ((qreal) _p_protein_match->getPeptideMatchList().at(row)->getCharge());
            }
            if (col ==6) {
                return _p_protein_match->getPeptideMatchList().at(row)->getPeptideXtpSp().get()->getSequence();
            }
            if (col ==7) {
                return _p_protein_match->getPeptideMatchList().at(row)->getPeptideXtpSp().get()->getModifString();
            }
            if (col ==8) {//label
                const Label * p_label = _p_protein_match->getPeptideMatchList().at(row)->getPeptideXtpSp().get()->getLabel();
                if (p_label != nullptr) {
                    return QVariant(p_label->getXmlId());
                }
                else {
                    return QVariant();
                }
            }
            if (col ==9) {
                return QVariant((qreal) _p_protein_match->getPeptideMatchList().at(row)->getStart()+1);
            }
            if (col ==10) {
                return QVariant((qreal) _p_protein_match->getPeptideMatchList().at(row)->getPeptideXtpSp().get()->size());
            }
            if (col ==11) {
                GroupingGroup * p_grp = _p_protein_match->getGroupingGroupSp().get();
                if (p_grp != nullptr) return QVariant((qreal)  p_grp->countSubgroupPresence(_p_protein_match->getPeptideMatchList().at(row)));
                return QVariant();
            }
            if (col ==12) {
                GroupingGroup * p_grp = _p_protein_match->getGroupingGroupSp().get();
                if (p_grp != nullptr) return QVariant( p_grp->getSubgroupIdList(_p_protein_match->getPeptideMatchList().at(row)).join(" "));
                return QVariant();
            }
            if (col ==13) {
                return QVariant((qreal) _p_protein_match->getPeptideMatchList().at(row)->getEvalue());
            }

            if (col ==14) {
                return QVariant((qreal) _p_protein_match->getPeptideMatchList().at(row)->getPeptideXtpSp().get()->getMz(1));

            }
            if (col ==15) {
                return QVariant((qreal) _p_protein_match->getPeptideMatchList().at(row)->getDeltaMass());

            }
            if (col ==16) {
                return _p_protein_match->getPeptideMatchList().at(row)->getParam(PeptideMatchParam::tandem_hyperscore);

            }
        }
        return QString("Row%1, Column%2")
               .arg(index.row() + 1)
               .arg(index.column() +1);
    }
    return QVariant();
}

void PeptideTableModel::onTableClicked(const QModelIndex &index)
{
    int row = index.row();
    int col = index.column();
    if (col == 0) //add a checkbox to cell(1,0)
    {
        if ( _p_protein_match->getPeptideMatchList().at(row)->isChecked()) {
            _p_protein_match->getPeptideMatchList().at(row)->setChecked(false);
        }
        else {
            _p_protein_match->getPeptideMatchList().at(row)->setChecked(true);
        }
        //emit dataChanged(index, index);
    }
    else {
        emit peptideMatchClicked(_p_protein_match->getPeptideMatchList().at(row));
    }
}

void PeptideTableModel::onPeptideDataChanged() {
    qDebug() << "PeptideTableModel::onPeptideDataChanged begin " << rowCount();
    emit layoutAboutToBeChanged();
    emit layoutChanged();
}
