
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of PAPPSOms-tools.
*
*     PAPPSOms-tools is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms-tools is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef QSPECTRUMWIDGET_H
#define QSPECTRUMWIDGET_H

#include <QWidget>
#include <QPainter>
#include <QMouseEvent>
#include <pappsomspp/spectrum/qualifiedspectrum.h>
#include <pappsomspp/peptide/peptide.h>
#include <pappsomspp/peptide/peptidefragmention.h>
#include "spectrumpainter.h"

using namespace pappso;

class QSpectrumWidget: public QWidget
{
    Q_OBJECT
public:
    QSpectrumWidget(QWidget *parent = 0);
    ~QSpectrumWidget();

    void paint(QPainter &painter);
    
    pappso_double getCanvasWidth() const {return _spectrum_painter.getCanvasWidth();};
    void setPeptideSp(pappso::PeptideSp & peptide_sp);
    void setPrecision(pappso::PrecisionP p_precision);
    void setIsotopeMassList(std::vector<pappso::PeptideNaturalIsotopeAverageSp> & isotopeMassList);
    
    SpectrumPainter & getSpectrumPainter() {return _spectrum_painter;}; 


public slots:
    void setQualifiedSpectrum(pappso::QualifiedSpectrum spectrum);

    // void setColor(const QColor &color);
    // void setShape(Shape shape);
signals:
    void mzChanged(double mz);

protected:
    void paintEvent(QPaintEvent *event) override;

private :
    SpectrumPainter _spectrum_painter;
};

#endif // QSPECTRUMWIDGET_H
