
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of PAPPSOms-tools.
*
*     PAPPSOms-tools is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     PAPPSOms-tools is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#include "overlaywidget.h"
#include <QDebug>



void LoadingOverlay::paintLoadingMessage(QPainter &painter) {

    if (_is_loading) {
        //p.fillRect(rect(), QColor(100, 100, 100, 128));
        painter.setPen(QColor(200, 200, 255, 255));
        painter.setFont(QFont("arial,helvetica", 48));
        painter.drawText(rect(), "Loading...", Qt::AlignHCenter | Qt::AlignVCenter);
    }
}
void LoadingOverlay::displayLoadingMessage() {
    _is_loading= true;
}
void LoadingOverlay::hideLoadingMessage() {
    _is_loading= false;
}
void LoadingOverlay::paintEvent(QPaintEvent *) {
    QPainter painter;

    painter.begin(this);
    painter.setRenderHint(QPainter::Antialiasing);
    qDebug() << "LoadingOverlay::paintEvent _is_loading="<< _is_loading;
    if (_is_loading) {
        paintLoadingMessage(painter);
    }
    else {
        paintUserSelectedZone(painter);
    }
    painter.end();
}
void LoadingOverlay::mousePressEvent(QMouseEvent * event) {

    qDebug() << " LoadingOverlay::mousePressEvent";

    _pressed = true;
    _first_point.first = event->x();
    _first_point.second = event->y();
    _current_mouse_mz = _p_spectrum_widget->getSpectrumPainter().getMzFromLocalPosX(event->x());

    _second_point.first = 0;
    emit mzChanged(_current_mouse_mz);
    update();
}


void LoadingOverlay::mouseReleaseEvent(QMouseEvent * event) {

    qDebug() << " LoadingOverlay::mouseReleaseEvent";
    _pressed = false;
    // _press_mz = _spectrum_painter.getMzFromLocalPosX(event->x());
    //_second_point.first = event->x();
    //_second_point.second = event->y();
    if (_second_point.first > 0) {
        mz min = _p_spectrum_widget->getSpectrumPainter().getMzFromLocalPosX(_first_point.first);
        mz max = _p_spectrum_widget->getSpectrumPainter().getMzFromLocalPosX(_second_point.first);
        if (max < min) {
            swap(min,max);
        }
        pappso_double max_intensity =  _p_spectrum_widget->getSpectrumPainter().getIntensityFromLocalPosY(_second_point.second);
        _p_spectrum_widget->getSpectrumPainter().setMinMz(min);
        _p_spectrum_widget->getSpectrumPainter().setMaxMz(max);
        _p_spectrum_widget->getSpectrumPainter().setMaxIntensity(max_intensity);
    }
    else {
        _p_spectrum_widget->getSpectrumPainter().setMaxMz(0);
    }
    _second_point.first = 0;
    update();

}
void LoadingOverlay::mouseMoveEvent(QMouseEvent * event) {
    qDebug() << "LoadingOverlay::mouseMoveEvent" << event->x();
    mz new_mz = _p_spectrum_widget->getSpectrumPainter().getMzFromLocalPosX(event->x());

    if (_pressed) {
        int min = _p_spectrum_widget->getSpectrumPainter().getMarginLeft();
        _second_point.first = event->x();
        if (_second_point.first < min) {
            _second_point.first = min;
        }
        int max = this->size().width();
        if (_second_point.first > max) {
            _second_point.first = max;
        }
        _second_point.second = event->y();

        if (_second_point.second < 0) {
            _second_point.second = 0;
        }

        max =  _p_spectrum_widget->getSpectrumPainter().getLocalPosYFromIntensity(0);
        if (_second_point.second > max) {
            _second_point.second = max;
        }

        _first_point.second = _p_spectrum_widget->getSpectrumPainter().getLocalPosYFromIntensity(0);
    }
    // if (_current_mouse_mz != new_mz) {
    _current_mouse_mz = new_mz;
    qDebug() << "LoadingOverlay::mouseMoveEvent emit mzChanged(_current_mouse_mz)" ;
    emit mzChanged(_current_mouse_mz);

    // if (_press_mz > 0) {
    update();

    // }
    // }
}


void LoadingOverlay::paintUserSelectedZone(QPainter & painter) {
    if (_second_point.first > 0) {
        painter.setPen(QColor("red"));
        QRect rect(_first_point.first, _first_point.second, _second_point.first-_first_point.first,  _second_point.second-_first_point.second);
        painter.drawRect(rect);

        // show the classname of the widget
        QBrush translucentBrush(QColor(255,246,240, 100));
        painter.fillRect(rect, translucentBrush);
    }

}
