
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/
#ifndef PEPTIDEWINDOW_H
#define PEPTIDEWINDOW_H

#include <QMainWindow>
#include <QTextDocument>
#include <QThread>
#include <pappsomspp/mass_range.h>
#include <pappsomspp/spectrum/spectrum.h>
#include "../../core/peptidematch.h"
#include "../../core/identificationgroup.h"
#include "spectrum_widget/overlaywidget.h"

class ProjectWindow;

namespace Ui {
class PeptideDetailView;
}


class SpectrumSpLoaderThread : public QObject
{
    Q_OBJECT
public:


public slots:
    void doLoadSpectrumSp(PeptideMatch * p_peptide_match);

signals:
    void spectrumSpReady(pappso::SpectrumSp spectrum_sp, QString error);
    
protected:

    void closeEvent(QCloseEvent *event);

};


class PeptideWindow: public QMainWindow {
    Q_OBJECT

public:

    explicit PeptideWindow(ProjectWindow * parent = 0);
    ~PeptideWindow();
    void setPeptideMatch(PeptideMatch * p_peptide_match);
    
public slots:
    void doIdentificationGroupGrouped(IdentificationGroup * p_identification_group);
    void setMz(double);
    
signals:
    void loadSpectrumSp(PeptideMatch * p_peptide_match);
    
protected slots:
    void doSpectrumSpReady(pappso::SpectrumSp spectrum_sp, QString error);
    void doMsmsPrecisionValueChanged(double precision_value);
    void doMsmsPrecisionUnitChanged(QString unit);
    void doSaveSvg();
    void chooseDefaultMzDataDir();
    void openInPeptideViewer();
protected :
    void updateDisplay();

private:
  
    QThread _spectrum_loader_thread;
    
    Ui::PeptideDetailView *ui;
    ProjectWindow * _p_project_window;
    PeptideMatch * _p_peptide_match = nullptr;
    pappso::PrecisionP _p_precision;
    
    LoadingOverlay * _p_spectrum_overlay;
    bool _spectrum_is_ready=false;

};

#endif // PEPTIDEWINDOW_H
