
/*******************************************************************************
* Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QFileInfo>
#include <QCloseEvent>
#include <pappsomspp/types.h>
#include <pappsomspp/peptide/peptide.h>
#include <pappsomspp/spectrum/spectrum.h>
#include <pwiz/data/msdata/MSDataFile.hpp>
#include "../utils/readspectrum.h"
#include "core/project.h"
#include "project_view/projectwindow.h"
#include "load_results_dialog/loadresultsdialog.h"
#include "export_spreadsheet_dialog/exportspreadsheetdialog.h"
#include "waiting_message_dialog/waitingmessagedialog.h"



namespace Ui {
class Main;
}

class MainWindow: public QMainWindow {
    Q_OBJECT

public:

    explicit MainWindow(QWidget * parent = 0);
    ~MainWindow();

public slots:
    void loadResults();
    void selectXpipFile();
    void doActionQuit();
    void doActionFasta();
    void doActionMassChroQ();
    void doActionProticDb();
    void doActionLabelingMethods();
    void doActionSpreadsheet();
    void doActionModifications();
    void doDisplayLoadingMessage(QString message);
    void doDisplayLoadingMessage(QString message, int value);
    void doProjectReady(ProjectSp project_sp);
    void doProjectNotReady(QString error);
    void doAcceptedLoadResultDialog();
    void doAcceptedExportSpreadsheetDialog();
    void doOperationFailed(QString);
    void doOperationFinished();
    void doGroupingFinished();
    void doActionSpectralCountingMcq();
    //void peptideEdited(QString peptideStr);
    // void setColor(const QColor &color);
    // void setShape(Shape shape);
signals:
    //void peptideChanged(pappso::PeptideSp peptide);
    void operateXpipFile(QString xpip_file);
    void operateLoadingResults(bool is_individual, AutomaticFilterParameters param, QStringList file_list);
    void operateWritingOdsFile(QString filename, ProjectSp project_sp);
    void operateWritingMassChroqFile(QString filename, ProjectSp project_sp);
    void operateWritingProticFile(QString filename, ProjectSp project_sp);
    void operateGrouping(ProjectSp project_sp);

protected:

    void closeEvent(QCloseEvent *event) override;
    void setProjectSp(ProjectSp project_sp);


private:

    void showWaitingMessage(const QString title);
    void hideWaitingMessage();
    void viewError(QString error);

private :
    Ui::Main *ui;
    QThread _worker_thread;
    ProjectSp _project_sp=nullptr;

    ProjectWindow * _project_window=nullptr;
    LoadResultsDialog * _p_load_results_dialog=nullptr;
    ExportSpreadsheetDialog * _p_export_spreadsheet_dialog;
    WaitingMessageDialog * _p_waiting_message_dialog;

};

#endif // MAINWINDOW_H
