
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/
#include "loadresultsdialog.h"

#include "ui_load_results_dialog.h"
#include <QDebug>
#include <QSettings>
#include <QFileDialog>
#include <QMessageBox>
#include <pappsomspp/pappsoexception.h>


LoadResultsDialog::LoadResultsDialog(QWidget * parent):
    QDialog(parent),
    ui(new Ui::LoadResultsDialog)
{
    qDebug() << "LoadResultsDialog::LoadResultsDialog begin";
    ui->setupUi(this);
    this->setModal(true);
    _p_file_list = new QStringListModel();


    _p_automatic_filter_widget = new AutomaticFilterWidget(this);
    _p_automatic_filter_widget->hideButton();
    
    QSettings settings;
    AutomaticFilterParameters param = _p_automatic_filter_widget->getAutomaticFilterParameters();
    param.setFilterCrossSamplePeptideNumber(settings.value("automatic_filter/cross_sample", "true").toBool());
    param.setFilterMinimumPeptidePerMatch((unsigned int) settings.value("automatic_filter/peptide_number", "2").toInt());
    param.setFilterPeptideEvalue(settings.value("automatic_filter/peptide_evalue", "0.05").toDouble());
    param.setFilterProteinEvalue(settings.value("automatic_filter/protein_evalue", "0.01").toDouble());
    _p_automatic_filter_widget->setAutomaticFilterParameters(param);

    
    
    
    ui->filter_parameter_layout->addWidget(_p_automatic_filter_widget);
#if QT_VERSION >= 0x050000
    // Qt5 code
    /*
    connect(&workerThread, &QThread::finished, worker, &QObject::deleteLater);
    connect(this, &PtSpectrumViewer::operateMsDataFile, worker, &PwizLoaderThread::doMsDataFileLoad);
    connect(worker, &PwizLoaderThread::msDataReady, this, &PtSpectrumViewer::handleMsDataFile);
    */
#else
// Qt4 code

#endif

    qDebug() << "LoadResultsDialog::LoadResultsDialog end";
}

LoadResultsDialog::~LoadResultsDialog()
{
    delete ui;
}

bool LoadResultsDialog::isIndividual() const {
    if (ui->individual_radio->isChecked()) {
        return true;
    }
}
QStringList LoadResultsDialog::getFileList() const {
    return _p_file_list->stringList();
}

AutomaticFilterParameters LoadResultsDialog::getAutomaticFilterParameters() const {
    return _p_automatic_filter_widget->getAutomaticFilterParameters();
}
    void LoadResultsDialog::clearFileList() {
        _p_file_list->removeRows( 0, _p_file_list->rowCount() );
    }
void LoadResultsDialog::chooseFiles() {
    try {
        QSettings settings;
        QString default_location = settings.value("path/identificationfiles", "").toString();

        QStringList filenames = QFileDialog::getOpenFileNames(this,tr("identification files"),default_location,
                                tr("X!Tandem files (*.xml);;all files (*)") );

        if (filenames.size() > 0) {
            settings.setValue("path/identificationfiles", QFileInfo(filenames[0]).absolutePath());
        }
        _p_file_list->setStringList(filenames);
        ui->file_list_view->setModel(_p_file_list);

    }
    catch (pappso::PappsoException & error) {
        //QMessageBox::warning(this,
        //                  tr("Error choosing identification result files : %1").arg(error.qwhat()), error);
    }
}
