
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef EXPORTSPREADSHEETDIALOG_H
#define EXPORTSPREADSHEETDIALOG_H

#include <QDialog>
#include <QStringListModel>
#include "../project_view/automatic_filter_widget/automaticfilterwidget.h"


namespace Ui {
class ExportSpreadsheetDialog;
}

class ProjectWindow;

class ExportSpreadsheetDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ExportSpreadsheetDialog(QWidget * parent);
    ~ExportSpreadsheetDialog();


public slots:
    void doSimpleProteinPeptideList(bool simple);
    void doProteinList(bool simple);
    void doGroups(bool simple);
    void doPeptidePos(bool simple);
    void doComparEmpai(bool simple);
    void doComparPai(bool simple);
    void doComparSpecificUniqueSequence(bool simple);
    void doComparUniqueSequence(bool simple);
    void doComparSpecificSpectra(bool simple);
    void doComparSpectra(bool simple);
    void doSamples(bool simple);
    void doSpectra(bool simple);
    void doPeptides(bool simple);
    void doProteins(bool simple);
    
signals:

private:
    Ui::ExportSpreadsheetDialog *ui;

};

#endif // EXPORTSPREADSHEETDIALOG_H
