
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "groupingpeptidemass.h"
#include "../core/proteinmatch.h"
#include "../core/peptidematch.h"

GroupingPeptideMass::GroupingPeptideMass()
{

    //_p_monitor = new pappso::GrpGroupingMonitor();
    _p_grp_experiment = new pappso::GrpExperiment(_p_monitor);

}

GroupingPeptideMass::~GroupingPeptideMass()
{
    delete _p_grp_experiment;
    delete _p_monitor;
}

pappso::GrpProteinSp & GroupingPeptideMass::getGrpProteinSp(ProteinMatch* p_protein_match) {
    return _p_grp_experiment->getGrpProteinSp(p_protein_match->getProteinXtpSp().get()->getAccession(),p_protein_match->getProteinXtpSp().get()->getDescription());
}
pappso::GrpPeptideSp & GroupingPeptideMass::setGrpPeptide(pappso::GrpProteinSp proteinSp, PeptideMatch* p_peptide_match) {

    return _p_grp_experiment->setGrpPeptide(proteinSp,p_peptide_match->getPeptideXtpSp().get()->getSequence(), p_peptide_match->getPeptideXtpSp().get()->getGroupingMass());
}

void GroupingPeptideMass::startGrouping() {
    _p_grp_experiment->startGrouping();
}

void GroupingPeptideMass::addPostGroupingGrpProteinSpRemoval(pappso::GrpProteinSp sp_protein) {
    _p_grp_experiment->addPostGroupingGrpProteinSpRemoval(sp_protein);
}
