
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PEPTIDEXTP_H
#define PEPTIDEXTP_H

#include <pappsomspp/peptide/peptide.h>
#include "labeling/labelingmethod.h"

class PeptideXtp;

/** \brief shared pointer on a Peptide object
 */
typedef std::shared_ptr<PeptideXtp> PeptideXtpSp;

class PeptideXtp : public pappso::Peptide
{
public:
    PeptideXtp(const QString & pepstr);
    PeptideXtp(const PeptideXtp& other);
    ~PeptideXtp();

    PeptideXtpSp makePeptideXtpSp() const;

    /** \brief get the tehoretical mass to use for grouping
     * This mass might be different than the true peptide mass to recognize that a tagged
     * peptide with taget modification is a light, inter or heavy version of the same peptide
    */
    pappso::mz getGroupingMass() const;

    const pappso::Peptide * getNativePeptideP() const;

    /** \brief human readable string that contains modifications
     * */
    const QString getModifString() const;

    /** @brief replace modification in peptide
     */
    bool replaceModification(pappso::AaModificationP oldmod, pappso::AaModificationP newmod);

    /** @brief reset label
     * */
    void clearLabel();
    /** @brief try to apply any label from this labeling method
     * */
    void applyLabelingMethod(LabelingMethodSp labeling_method_sp);
    
    /** @brief get label
     * */
    const Label * getLabel() const;

private:
    /** \brief if the peptide is tagged, this is the native peptide without tags
     */
    pappso::PeptideSp _sp_native_peptide = nullptr;

    Label * _p_label = nullptr;


};

#endif // PEPTIDEXTP_H
