
/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#include "identificationdatasource.h"
#include "identificationxtandemfile.h"
#include <pappsomspp/pappsoexception.h>
#include <QFileInfo>
#include "../../utils/readspectrum.h"


IdentificationDataSource::IdentificationDataSource(const QString resource_name)
{
    _resource_name = resource_name;
}

IdentificationDataSource::IdentificationDataSource(const IdentificationDataSource& other)
{
    _ms_run_sp = other._ms_run_sp;
    _resource_name = other._resource_name;
}

IdentificationDataSource::~IdentificationDataSource()
{

}

bool IdentificationDataSource::operator==(const IdentificationDataSource& other) const
{

}

const QString & IdentificationDataSource::getResourceName () const {
    return _resource_name;
}

const QString IdentificationDataSource::getSampleName () const {
    return _ms_run_sp.get()->getSampleName();
}

void IdentificationDataSource::setMsRunSp (MsRunSp ms_run_sp) {
    _ms_run_sp = ms_run_sp;
}
MsRunSp IdentificationDataSource::getMsRunSp () const {
    return (_ms_run_sp);
}

IdentificationEngine IdentificationDataSource::getIdentificationEngine() const {
    return _engine;
}
const QString IdentificationDataSource::getIdentificationEngineName() const {
    QString name = "unknown";
    switch (_engine) {
    case IdentificationEngine::XTandem :
        name = "X!Tandem";
        break;
    case IdentificationEngine::peptider :
        name = "peptider";
        break;
    }
    return name;
}
const QString& IdentificationDataSource::getIdentificationEngineVersion() const {
    return _version;
}
void IdentificationDataSource::setIdentificationEngineVersion(const QString& version) {
    _version = version;
}
void IdentificationDataSource::setIdentificationEngineParam(IdentificationEngineParam param, const QVariant& value) {
    _params.insert(std::pair<IdentificationEngineParam, QVariant>(param, value));
}

const QVariant IdentificationDataSource::getIdentificationEngineParam(IdentificationEngineParam param) const {
    try {
        return _params.at(param);
    }
    catch (std::out_of_range) {
        return QVariant();
    }
}
pappso::SpectrumSp IdentificationDataSource::getSpectrumSp(unsigned int scan_number) const {
    pappso::SpectrumSp spectrum_sp = SpectrumStore::getSpectrumSpFromMsRunSp(_ms_run_sp, scan_number);
    return spectrum_sp;
}

void IdentificationDataSource::addFastaFile (FastaFileSp file) {
    _fastafile_list.push_back(file);
}
const std::vector<FastaFileSp> & IdentificationDataSource::getFastaFileList() const {
    qDebug()<<  "IdentificationDataSource::getFastaFileList begin" << _fastafile_list.size();
    return _fastafile_list;
}
