
/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of XTPcpp.
*
*     XTPcpp is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     XTPcpp is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with XTPcpp.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "automaticfilterparameters.h"

AutomaticFilterParameters::AutomaticFilterParameters()
{

}

AutomaticFilterParameters::AutomaticFilterParameters(const AutomaticFilterParameters& other)
{
    _filter_minimum_peptide_evalue=other._filter_minimum_peptide_evalue;
    _filter_minimum_protein_evalue=other._filter_minimum_protein_evalue;
    _filter_minimum_peptide_per_match=other._filter_minimum_peptide_per_match;
    _filter_is_cross_sample_peptide_number=other._filter_is_cross_sample_peptide_number;
}

AutomaticFilterParameters::~AutomaticFilterParameters()
{

}

void AutomaticFilterParameters::setFilterPeptideEvalue( pappso::pappso_double evalue) {
    _filter_minimum_peptide_evalue = evalue;
}

void AutomaticFilterParameters::setFilterProteinEvalue( pappso::pappso_double evalue) {
    _filter_minimum_protein_evalue = evalue;
}
void AutomaticFilterParameters::setFilterMinimumPeptidePerMatch(unsigned int number) {
    _filter_minimum_peptide_per_match = number;
}
void AutomaticFilterParameters::setFilterCrossSamplePeptideNumber(bool cross) {
    _filter_is_cross_sample_peptide_number = cross;
}
pappso::pappso_double AutomaticFilterParameters::getFilterPeptideEvalue() const {
    return (_filter_minimum_peptide_evalue );
}
pappso::pappso_double AutomaticFilterParameters::getFilterProteinEvalue() const {
    return ( _filter_minimum_protein_evalue );
}
unsigned int AutomaticFilterParameters::getFilterMinimumPeptidePerMatch()const {
    return (_filter_minimum_peptide_per_match );
}
bool AutomaticFilterParameters::getFilterCrossSamplePeptideNumber()const {
    return _filter_is_cross_sample_peptide_number ;
}
