/**
 * \file utils/threadexception.cpp
 * \author Olivier Langella
 * \brief QT exception that can be thrown between threads
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/
#include "threadexception.h"

ThreadException::ThreadException(QString message) {
    _message = message;
}
ThreadException::ThreadException(const ThreadException & other):QtConcurrent::Exception(other) {
    _message = other._message;
}

const QString & ThreadException::qwhat() const {
    return _message;
}
