/**
 * \file utils/phase1wrapper.h
 * \author Olivier Langella
 * \brief wrappers to handle Physikron phase 1
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef PHASE1WRAPPER_H
#define PHASE1WRAPPER_H

#include <QString>

class Phase1Wrapper
{
public:
    Phase1Wrapper(const QString & phase1_exe);
    void setAccuracy(double accuracy);
    void setWindowDalton(double window_dalton);
    void setWorkingDirectory(const QString & phase1_working_directory);
    void run (const QString & mgf_input_file, const QString & hk_input_file, const QString & mgf_output_file);
private:
    const QString _phase1_exe;
    double _window_dalton=3;
    double _accuracy_ppm=10;
    int _max_hk_time_ms = (1000 * 60 * 60); //1 hour
    QString _phase1_working_directory;
};

#endif // PHASE1WRAPPER_H
