/**
 * \file utils/linearregression.h
 * \date 17/9/2016
 * \author Olivier Langella
 * \brief compute linear regression
 */

/*******************************************************************************
 * Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of peptider.
 *
 *     peptider is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     peptider is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
 ******************************************************************************/
#ifndef LINEARREGRESSION_H
#define LINEARREGRESSION_H
#include <pappsomspp/types.h>
#include <vector>

class LinearRegression
{
public:
    LinearRegression(const std::vector<pappso::pappso_double> & x_vec, const std::vector<pappso::pappso_double> & y_vec);
    pappso::pappso_double getYfromX(pappso::pappso_double score)const;
    pappso::pappso_double getIntercept()const;
    pappso::pappso_double getSlope()const;

private:
    pappso::pappso_double _slope=0;
    pappso::pappso_double _intercept=0;
};

#endif // LINEARREGRESSION_H
