/**
 * \file mzdatareporter.h
 * \author Olivier Langella
 * \brief write identification results to new MZ file
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef MZDATAREPORTER_H
#define MZDATAREPORTER_H

#include "basepsmreporter.h"
#include <pwiz/data/msdata/MSDataFile.hpp>

class MzDataReporter: public BasePsmReporter
{
public:
    MzDataReporter(const QString & mz_data_file, const QString & out_filename);
    ~MzDataReporter();

    virtual void writeResults(const MzData * p_mzdata) override;
    virtual void close() override;

protected:
    virtual void write(const SpectrumDataCollector & spectrum);
    pappso::QualifiedSpectrum getQualifiedSpectrum(size_t scan_number) const;
    const pappso::Peak findPrecursorPeak(size_t scan_number, pappso::mz precursor_mz) const;
    void insertPhysikronPairInPwizData(const SpectrumDataCollector & physikron_spectrum);
    void insertPhysikronFullInPwizData(const SpectrumDataCollector & physikron_spectrum);

private :

    pwiz::msdata::MSDataFile * _p_pwizdata;
    QString _out_filename;
    pwiz::msdata::SpectrumListPtr _sp_spectrum_list_ptr;
    size_t _current_scan_index = 0;
    size_t _total_scan_number = 0;
    pappso::MsRunId _msrun_id;
    pwiz::msdata::CVID _native_id_format;
    pwiz::msdata::CVID _new_native_id_format;

    pwiz::msdata::SpectrumListSimplePtr _new_spectrum_list;
    unsigned int _new_index=0;

    pwiz::msdata::MSData _new_pwizdata;
    pappso::PrecisionP _precision_upper ;
    pappso::PrecisionP _precision_lower ;



};

#endif // MZDATAREPORTER_H
