/**
 * \file reporter/basepsmreporter.h
 * \date 10/9/2016
 * \author Olivier Langella
 * \brief base interface to report identification results
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#ifndef BASEPSMREPORTER_H
#define BASEPSMREPORTER_H

#include "../core/spectrumdatacollector.h"
#include "../core/struct.h"

class MzData;
class DigestionPipeline;

class BasePsmReporter
{
public:
    BasePsmReporter();
    ~BasePsmReporter();

    virtual void writeResults(const MzData * p_mzdata)=0;
    virtual void close()=0;
    void setFastaDatabaseList(std::vector< FastaDatabase > fasta_file_list);


protected :


    virtual std::vector<PsmScore> getPsmScoreList(const SpectrumDataCollector & spectrum) const;

protected :
    size_t _total_spectrum_number = 0;
    size_t _total_spectrum_used = 0;

    std::vector< FastaDatabase > _fasta_file_list;
    const DigestionPipeline* _p_digestion_pipeline;

};

#endif // BASEPSMREPORTER_H
