
/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#ifndef XTANDEMSPECTRUMPREPARE_H
#define XTANDEMSPECTRUMPREPARE_H

#include <QRunnable>
#include "mzdata.h"
#include "customspectrum.h"
#include <pappsomspp/psm/xtandem/xtandemspectrumprocess.h>

class XtandemSpectrumPrepare: public QRunnable
{
public:
    XtandemSpectrumPrepare(MzData * p_mzdata, CustomSpectrum spectrum, pappso::PrecisionP precision_lower, pappso::PrecisionP precision_upper);
    XtandemSpectrumPrepare(const XtandemSpectrumPrepare& other);
    ~XtandemSpectrumPrepare();

    virtual void run() override;
    
private :
    pappso::SpectrumSp processSpectrum (const pappso::Spectrum * p_spectrum) const;

private :
    MzData * _p_mzdata;
    CustomSpectrum _spectrum;
    pappso::PrecisionP _precision_lower = nullptr;
    pappso::PrecisionP _precision_upper = nullptr;
    unsigned int _minimum_number_of_peaks = 5;
    unsigned int _maximum_peptide_charge = 3;
    pappso::mz _minimum_mz;
    pappso::pappso_double _dynamic_range;
};

#endif // XTANDEMSPECTRUMPREPARE_H
