
/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/

#include "xtandemspectrumprepare.h"
#include "spectrumdatacollector.h"
#include <QDebug>
#include <pappsomspp/exception/exceptionoutofrange.h>
#include "../utils/peptiderparams.h"

XtandemSpectrumPrepare::XtandemSpectrumPrepare(MzData * p_mzdata, CustomSpectrum spectrum, pappso::PrecisionP precision_lower, pappso::PrecisionP precision_upper)
    :_p_mzdata(p_mzdata), _spectrum(spectrum)
{
    _precision_lower = precision_lower;
    _precision_upper = precision_upper;
    _minimum_number_of_peaks = (unsigned int) PeptiderParams::Instance().get(PeptiderParamPappsoDouble::TandemSpectrumModelMinimumNumberOfPeaks);
    _minimum_mz = PeptiderParams::Instance().get(PeptiderParamPappsoDouble::SpectrumModelMinimumMz);
    _dynamic_range = PeptiderParams::Instance().get(PeptiderParamPappsoDouble::TandemSpectrumModelDynamicRange);
}

XtandemSpectrumPrepare::XtandemSpectrumPrepare(const XtandemSpectrumPrepare& other)
    :_p_mzdata(other._p_mzdata), _spectrum(other._spectrum) {
}
XtandemSpectrumPrepare::~XtandemSpectrumPrepare()
{
    qDebug() << "XtandemSpectrumPrepare::~XtandemSpectrumPrepare" ;
}

pappso::SpectrumSp XtandemSpectrumPrepare::processSpectrum (const pappso::Spectrum * p_spectrum) const {
    pappso::Spectrum spectrum_process(*p_spectrum);
                     spectrum_process = spectrum_process.removeMzUnder(_minimum_mz).applyDynamicRange(_dynamic_range).removeIntensityUnder(1);
                    return spectrum_process.makeSpectrumSp();
}


void XtandemSpectrumPrepare::run() {
    if (_spectrum.getMsLevel() == 1) return;
    if (_spectrum.getOriginalSpectrumSp().get()->size() > 0) {

        try {

            qDebug() << "XtandemSpectrumPrepare::run charge==0" ;
            CustomSpectrum new_spectrum(_spectrum);
            SpectrumDataCollector collector(new_spectrum, _precision_lower, _precision_upper);

            if (_spectrum.getPrecursorCharge() == 0) {
                unsigned int charge = _maximum_peptide_charge;
                while (charge > 0) {
                    pappso::SpectrumSp new_sp = processSpectrum(_spectrum.getOriginalSpectrumSp().get());
                    if (new_sp.get()->size() >=_minimum_number_of_peaks) {
                        //collector.set
                        collector.addSpectrumSpCharge(new_sp, charge);
                    }
                    charge--;
                }
            }
            else {
                pappso::SpectrumSp new_sp = processSpectrum(_spectrum.getOriginalSpectrumSp().get());
                if (new_sp.get()->size() >=_minimum_number_of_peaks) {
                    //collector.set
                    collector.addSpectrumSpCharge(new_sp, _spectrum.getPrecursorCharge());
                }
            }
            _p_mzdata->addSpectrumDataCollectorSp(collector.makeSpectrumDataCollectorSp());

        }
        catch (pappso::PappsoException exception) {
            qDebug() << "XtandemSpectrumPrepare::run ERROR "  << exception.qwhat() ;
        }
    }
}
