#ifndef STRUCT_H
#define STRUCT_H

#include <pappsomspp/protein/protein.h>
#include <pappsomspp/peptide/peptide.h>
#include <QFileInfo>


struct FastaDatabase {
  std::int8_t sequence_database_id;
  QFileInfo sequence_database_file_info;
  bool is_reverse;
};


struct DigestProduct {
  std::int8_t sequence_database_id;
  pappso::ProteinSp protein_sp;
  pappso::PeptideSp peptide_sp;
  pappso::mz mz;
  unsigned int charge;
  unsigned int start;
  bool is_nter;
  unsigned int missed_cleavage_number;
  bool semi_enzyme;
  bool reverse;
  std::int8_t c13; 
};



struct PsmScore {
  DigestProduct digest_product;
  pappso::pappso_double hyperscore;
  unsigned int total_ion_match;
};

#endif // STRUCT_H
