/**
 * \file core/spectrumcompletor.h
 * \author Olivier Langella
 * \brief complete spectrum
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#ifndef SPECTRUMCOMPLETOR_H
#define SPECTRUMCOMPLETOR_H

#include<pappsomspp/spectrum/spectrum.h>
#include<pappsomspp/peptide/peptide.h>

class SpectrumCompletor
{
public:
    SpectrumCompletor(pappso::PrecisionP precision, const std::vector<pappso::PeptideIon> & ion_list);
    virtual ~SpectrumCompletor();
    
    pappso::SpectrumSp completeSpectrum(pappso::PeptideSp & peptide_sp, const pappso::Spectrum * complete_spectrum, const pappso::Spectrum * pair_spectrum, unsigned int parent_charge) const;
    
private:
    pappso::PrecisionP _precision=nullptr;
    std::list<pappso::PeptideIon> _ion_list;
};

#endif // SPECTRUMCOMPLETOR_H
