/**
 * \file core/spectrumcompletor.cpp
 * \author Olivier Langella
 * \brief complete spectrum
 */

/*******************************************************************************
* Copyright (c) 2017 Olivier Langella <olivier.langella@u-psud.fr>.
*
* This file is part of phase2.
*
*     phase2 is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     phase2 is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with phase2.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <olivier.langella@u-psud.fr> - initial API and implementation
******************************************************************************/

#include "spectrumcompletor.h"
#include <pappsomspp/psm/peptidespectrummatch.h>
#include <QDebug>

SpectrumCompletor::SpectrumCompletor(pappso::PrecisionP precision, const std::vector<pappso::PeptideIon> & ion_list) {
    _precision = precision;

    for (auto ion : ion_list) {
        _ion_list.push_back(ion);
    }
}

SpectrumCompletor::~SpectrumCompletor() {
}

pappso::SpectrumSp SpectrumCompletor::completeSpectrum(pappso::PeptideSp & peptide_sp, const pappso::Spectrum * complete_spectrum, const pappso::Spectrum * pair_spectrum, unsigned int parent_charge) const {

    //qDebug() << "SpectrumCompletor::completeSpectrum begin";
    pappso::PeptideSpectrumMatch psm(*complete_spectrum, peptide_sp, parent_charge, _precision, _ion_list);

    pappso::Spectrum spectrum(*pair_spectrum);
    for (pappso::PeakIonMatch ion : psm) {
        spectrum.push_back(ion.getPeak());
    }
   // qDebug() << "SpectrumCompletor::completeSpectrum begin " << spectrum.size();
    spectrum.sortMz();
    spectrum.unique();

    //qDebug() << "SpectrumCompletor::completeSpectrum end " << spectrum.size();
    return (spectrum.makeSpectrumSp());

}
