/**
 * \file core/secondpass.h
 * \date 1/12/2016
 * \author Olivier Langella
 * \brief digestion pipeline for the second identification pass
 */

/*******************************************************************************
* Copyright (c) 2016 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
*
* This file is part of peptider.
*
*     peptider is free software: you can redistribute it and/or modify
*     it under the terms of the GNU General Public License as published by
*     the Free Software Foundation, either version 3 of the License, or
*     (at your option) any later version.
*
*     peptider is distributed in the hope that it will be useful,
*     but WITHOUT ANY WARRANTY; without even the implied warranty of
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*     GNU General Public License for more details.
*
*     You should have received a copy of the GNU General Public License
*     along with peptider.  If not, see <http://www.gnu.org/licenses/>.
*
* Contributors:
*     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and implementation
******************************************************************************/
#ifndef SECONDPASS_H
#define SECONDPASS_H

class SecondPass
{
public:
    SecondPass(MzData * p_mzdata);
    ~SecondPass();
private:
  
    struct ProteinDb {
        const pappso::Protein * _p_protein;
        std::int8_t _database_id;
	bool _reverse;
        bool operator==(const ProteinDb& rhs) {
            return (_p_protein == rhs._p_protein);
        }
        bool operator<(const ProteinDb& rhs) {
            return (_p_protein < rhs._p_protein);
        }
    };
    std::vector<SecondPass::ProteinDb> _p_protein_list;
};

#endif // SECONDPASS_H
